/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.util.Map;
import org.apache.camel.component.quartz.QuartzExchange;
import org.apache.camel.impl.DefaultMessage;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzMessage
extends DefaultMessage {
    private final JobExecutionContext jobExecutionContext;

    public QuartzMessage(QuartzExchange exchange, JobExecutionContext jobExecutionContext) {
        this.jobExecutionContext = jobExecutionContext;
        this.setExchange(exchange);
        this.setBody(jobExecutionContext.getJobDetail());
    }

    public JobExecutionContext getJobExecutionContext() {
        return this.jobExecutionContext;
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        super.populateInitialHeaders(map);
        if (this.jobExecutionContext != null) {
            map.put("calendar", this.jobExecutionContext.getCalendar());
            map.put("fireTime", this.jobExecutionContext.getFireTime());
            map.put("jobDetail", this.jobExecutionContext.getJobDetail());
            map.put("jobInstance", this.jobExecutionContext.getJobInstance());
            map.put("jobRunTime", this.jobExecutionContext.getJobRunTime());
            map.put("mergedJobDataMap", this.jobExecutionContext.getMergedJobDataMap());
            map.put("nextFireTime", this.jobExecutionContext.getNextFireTime());
            map.put("previousFireTime", this.jobExecutionContext.getPreviousFireTime());
            map.put("refireCount", this.jobExecutionContext.getRefireCount());
            map.put("result", this.jobExecutionContext.getResult());
            map.put("scheduledFireTime", this.jobExecutionContext.getScheduledFireTime());
            map.put("scheduler", this.jobExecutionContext.getScheduler());
            Trigger trigger = this.jobExecutionContext.getTrigger();
            map.put("trigger", trigger);
            map.put("triggerName", trigger.getName());
            map.put("triggerGroup", trigger.getGroup());
        }
    }
}

