/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.mock.MockEndpoint;

public class FileRouteGenerateEmptyExchangeWhenIdleTest
extends ContextTestSupport {
    protected Object expectedBody = "Hello there!";
    protected String uri = "file:target/test-inbox2?consumer.generateEmptyExchangeWhenIdle=true";

    public void testFileRoute() throws Exception {
        MockEndpoint result = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedMinimumMessageCount(2);
        result.setResultWaitTime(5000L);
        this.template.sendBodyAndHeader(this.uri, this.expectedBody, "cheese", (Object)123);
        result.assertIsSatisfied();
        int fileCount = 0;
        int nullCount = 0;
        for (Exchange exchange : result.getReceivedExchanges()) {
            FileRouteGenerateEmptyExchangeWhenIdleTest.assertTrue((boolean)(exchange instanceof FileExchange));
            FileExchange fx = (FileExchange)exchange;
            if (fx.getFile() == null) {
                ++nullCount;
                continue;
            }
            ++fileCount;
        }
        FileRouteGenerateEmptyExchangeWhenIdleTest.assertEquals((int)1, (int)fileCount);
        FileRouteGenerateEmptyExchangeWhenIdleTest.assertTrue((nullCount > 0 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        FileRouteGenerateEmptyExchangeWhenIdleTest.deleteDirectory("target/test-inbox2");
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileRouteGenerateEmptyExchangeWhenIdleTest.this.uri).to("mock:result");
            }
        };
    }
}

