/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class FileAsyncRouteTest
extends ContextTestSupport {
    protected Object expectedBody = "Hello there!";
    protected String uri = "file:target/test-async-inbox?delete=true";
    CountDownLatch receivedLatch = new CountDownLatch(1);
    CountDownLatch processingLatch = new CountDownLatch(1);
    AtomicReference<File> file = new AtomicReference();

    protected void setUp() throws Exception {
        FileAsyncRouteTest.deleteDirectory("target/test-async-inbox");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.processingLatch.countDown();
        this.receivedLatch.countDown();
        super.tearDown();
    }

    public void testFileRoute() throws Exception {
        MockEndpoint result = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(this.expectedBody);
        result.setResultWaitTime(5000L);
        this.template.sendBodyAndHeader(this.uri, this.expectedBody, "cheese", (Object)123);
        FileAsyncRouteTest.assertTrue((String)"Async processor received exchange", (boolean)this.receivedLatch.await(5L, TimeUnit.SECONDS));
        File file = this.file.get();
        Thread.sleep(1000L);
        FileAsyncRouteTest.assertTrue((String)"File should exist", (boolean)file.exists());
        this.processingLatch.countDown();
        Thread.sleep(1000L);
        FileAsyncRouteTest.assertFalse((String)"File should not exist", (boolean)file.exists());
        result.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileAsyncRouteTest.this.uri).thread(1).to("direct:a");
                ((ProcessorType)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        FileAsyncRouteTest.this.file.set((File)exchange.getIn().getBody());
                        FileAsyncRouteTest.this.receivedLatch.countDown();
                        FileAsyncRouteTest.this.processingLatch.await();
                    }
                })).to("mock:result");
            }
        };
    }
}

