/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.logging.Logger;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.DOMInInterceptor;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.camel.component.cxf.interceptors.FaultOutInterceptor;
import org.apache.camel.component.cxf.interceptors.PayloadContentRedirectInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;

public class PayLoadDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageDataFormatFeature.class);
    private static final String[] REMOVING_IN_PHASES = new String[]{"unmarshal", "pre-logical", "pre-logical-ending", "post-logical", "post-logical-ending"};
    private static final String[] REMOVING_OUT_PHASES = new String[]{"marshal", "marshal-ending", "pre-logical", "pre-logical-ending", "post-logical", "post-logical-ending"};

    public void initialize(Client client, Bus bus) {
        this.removeInterceptorWhichIsInThePhases(client.getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getService().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getBinding().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getOutInterceptors(), REMOVING_OUT_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getService().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.removeInterceptorWhichIsInThePhases(client.getEndpoint().getBinding().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.addDataHandlingInterceptors(client.getEndpoint().getBinding());
        client.getEndpoint().getBinding().getOutFaultInterceptors().add(new FaultOutInterceptor());
    }

    public void initialize(Server server, Bus bus) {
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getService().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getBinding().getInInterceptors(), REMOVING_IN_PHASES);
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getService().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.removeInterceptorWhichIsInThePhases(server.getEndpoint().getBinding().getOutInterceptors(), REMOVING_OUT_PHASES);
        this.resetServiceInvokerInterceptor(server);
        this.addDataHandlingInterceptors(server.getEndpoint().getBinding());
        server.getEndpoint().getBinding().getOutFaultInterceptors().add(new FaultOutInterceptor());
    }

    private void addDataHandlingInterceptors(Binding binding) {
        binding.getInInterceptors().add(new DOMInInterceptor());
        binding.getOutInterceptors().add(new DOMOutInterceptor());
        binding.getOutInterceptors().add(new PayloadContentRedirectInterceptor());
    }

    protected Logger getLogger() {
        return LOG;
    }
}

