/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.naming.Context;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanWithHeadersAndBodyInjectionTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("p1", "abc");
                exchange.setProperty("p2", 123);
                Message in = exchange.getIn();
                in.setHeader("h1", "xyz");
                in.setHeader("h2", 456);
                in.setBody("TheBody");
            }
        });
        Map<String, Object> foo = this.myBean.headers;
        BeanWithHeadersAndBodyInjectionTest.assertNotNull((String)"myBean.foo", foo);
        BeanWithHeadersAndBodyInjectionTest.assertEquals((String)"foo.h1", (Object)"xyz", (Object)foo.get("h1"));
        BeanWithHeadersAndBodyInjectionTest.assertEquals((String)"foo.h2", (Object)456, (Object)foo.get("h2"));
        BeanWithHeadersAndBodyInjectionTest.assertEquals((String)"body", (Object)"TheBody", (Object)this.myBean.body);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyBean {
        public Map<String, Object> headers;
        public Object body;

        public String toString() {
            return "MyBean[foo: " + this.headers + " body: " + this.body + "]";
        }

        public void myMethod(@Headers Map<String, Object> headers, Object body) {
            this.headers = headers;
            this.body = body;
            LOG.info((Object)("myMethod() method called on " + this));
        }

        public void anotherMethod(@Headers Map<String, Object> headers, Object body) {
            Assert.fail((String)"Should not have called this method!");
        }
    }
}

