/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.List;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Language;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.jndi.JndiTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextTestSupport
extends TestSupport {
    protected CamelContext context;
    protected CamelTemplate<Exchange> template;
    private boolean useRouteBuilder = true;
    private Service camelContextService;

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public void setCamelContextService(Service camelContextService) {
        this.camelContextService = camelContextService;
    }

    protected void setUp() throws Exception {
        this.context = this.createCamelContext();
        this.assertValidContext(this.context);
        this.template = new CamelTemplate(this.context);
        if (this.useRouteBuilder) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug((Object)("Using created route builder: " + builder));
                this.context.addRoutes(builder);
            }
        } else {
            this.log.debug((Object)("Using route builder from the created context: " + this.context));
        }
        this.startCamelContext();
        this.log.debug((Object)("Routing Rules are: " + this.context.getRoutes()));
    }

    protected void tearDown() throws Exception {
        this.log.debug((Object)("tearDown test: " + this.getName()));
        this.template.stop();
        this.stopCamelContext();
    }

    protected void stopCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.stop();
        } else {
            this.context.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext(this.createRegistry());
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        return JndiTest.createInitialContext();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return this.resolveMandatoryEndpoint(this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("testCase", ContextTestSupport.this.getName());
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody(this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression<Exchange> expression = language.createExpression(expressionText);
        ContextTestSupport.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), expression);
        this.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate<Exchange> predicate = language.createPredicate(expressionText);
        ContextTestSupport.assertNotNull((String)("No Predicate could be created for text: " + expressionText + " language: " + language), predicate);
        this.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        ContextTestSupport.assertNotNull((String)("No language found for name: " + languageName), (Object)language);
        return language;
    }

    protected void assertMockEndpointsSatisifed() throws InterruptedException {
        MockEndpoint.assertIsSatisfied(this.context);
    }

    protected void assertValidContext(CamelContext context) {
        ContextTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }

    protected <T> List<T> getSingletonEndpoints(Class<T> type) {
        return CamelContextHelper.getSingletonEndpoints(this.context, type);
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        T endpoint = this.context.getEndpoint(uri, type);
        ContextTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), endpoint);
        return endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        ContextTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return endpoint;
    }
}

