/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BodyAndHeaderConvertTest
extends TestCase {
    protected Exchange exchange;

    public void testConversionOfBody() throws Exception {
        Document document = this.exchange.getIn().getBody(Document.class);
        BodyAndHeaderConvertTest.assertNotNull((Object)document);
        Element element = document.getDocumentElement();
        BodyAndHeaderConvertTest.assertEquals((String)"Root element name", (String)"hello", (String)element.getLocalName());
    }

    public void testConversionOfExchangeProperties() throws Exception {
        String text = this.exchange.getProperty("foo", String.class);
        BodyAndHeaderConvertTest.assertEquals((String)"foo property", (String)"1234", (String)text);
    }

    public void testConversionOfMessageHeaders() throws Exception {
        String text = this.exchange.getIn().getHeader("bar", String.class);
        BodyAndHeaderConvertTest.assertEquals((String)"bar header", (String)"567", (String)text);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange(new DefaultCamelContext());
        this.exchange.setProperty("foo", 1234);
        Message message = this.exchange.getIn();
        message.setBody("<hello>world!</hello>");
        message.setHeader("bar", 567);
    }
}

