/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="unmarshal")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UnmarshalType
extends OutputType {
    @XmlAttribute(required=false)
    private String ref;
    @XmlElementRef
    private DataFormatType dataFormatType;

    public UnmarshalType() {
    }

    public UnmarshalType(DataFormatType dataFormatType) {
        this.dataFormatType = dataFormatType;
    }

    public UnmarshalType(String ref) {
        this.ref = ref;
    }

    public String toString() {
        if (this.dataFormatType != null) {
            return "Marshal[" + this.dataFormatType + "]";
        }
        return "Marshal[ref:  " + this.ref + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormatType;
    }

    public void setDataFormatType(DataFormatType dataFormatType) {
        this.dataFormatType = dataFormatType;
    }

    public Processor createProcessor(RouteContext routeContext) {
        DataFormatType type = this.getDataFormatType();
        if (type == null) {
            ObjectHelper.notNull(this.ref, "ref or dataFormatType");
            type = routeContext.lookup(this.ref, DataFormatType.class);
        }
        DataFormat dataFormat = type.getDataFormat(routeContext);
        return new UnmarshalProcessor(dataFormat);
    }
}

