/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="catch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CatchType
extends ProcessorType {
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();
    @XmlTransient
    private List<Class> exceptionClasses;

    public CatchType() {
    }

    public CatchType(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchType(Class exceptionType) {
        this.exceptionClasses = new ArrayList<Class>();
        this.exceptionClasses.add(exceptionType);
    }

    public String toString() {
        return "Catch[ " + this.getExceptionClasses() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return this.getExceptionClasses().toString();
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        return new CatchProcessor(this.getExceptionClasses(), childProcessor);
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
    }

    public List<Class> getExceptionClasses() {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = this.createExceptionClasses();
        }
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    protected List<Class> createExceptionClasses() {
        List<String> list = this.getExceptions();
        ArrayList<Class> answer = new ArrayList<Class>(list.size());
        for (String name : list) {
            Class<?> type = ObjectHelper.loadClass(name, this.getClass().getClassLoader());
            answer.add(type);
        }
        return answer;
    }
}

