/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmComponent
extends SedaComponent {
    private static final AtomicInteger START_COUNTER = new AtomicInteger();
    protected static Map<String, BlockingQueue> queues = new HashMap<String, BlockingQueue>();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        BlockingQueue<Exchange> blockingQueue = this.getBlockingQueue(uri);
        return new SedaEndpoint(uri, this, blockingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockingQueue<Exchange> getBlockingQueue(String uri) {
        Map<String, BlockingQueue> map = queues;
        synchronized (map) {
            BlockingQueue<Exchange> answer = queues.get(uri);
            if (answer == null) {
                answer = this.createQueue();
                queues.put(uri, answer);
            }
            return answer;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (START_COUNTER.decrementAndGet() == 0) {
            Map<String, BlockingQueue> map = queues;
            synchronized (map) {
                for (BlockingQueue q : queues.values()) {
                    q.clear();
                }
                queues.clear();
            }
        }
    }
}

