/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaEndpoint
extends DefaultEndpoint<Exchange> {
    private BlockingQueue<Exchange> queue;

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue) {
        super(endpointUri, component);
        this.queue = queue;
    }

    public SedaEndpoint(String uri, SedaComponent component) {
        this(uri, component, component.createQueue());
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SedaProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new SedaConsumer(this, processor);
    }

    public BlockingQueue<Exchange> getQueue() {
        return this.queue;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private final class SedaProducer
    extends DefaultProducer
    implements AsyncProcessor {
        private SedaProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) {
            SedaEndpoint.this.queue.add(exchange.copy());
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            SedaEndpoint.this.queue.add(exchange.copy());
            callback.done(true);
            return true;
        }
    }
}

