/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class MinaProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(MinaProducer.class);
    private static final long MAX_WAIT_RESPONSE = 10000L;
    private IoSession session;
    private MinaEndpoint endpoint;
    private CountDownLatch latch;

    public MinaProducer(MinaEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Object body;
        if (this.session == null) {
            throw new IllegalStateException("Not started yet!");
        }
        if (!this.session.isConnected()) {
            this.doStart();
        }
        if ((body = exchange.getIn().getBody()) == null) {
            LOG.warn("No payload for exchange: " + exchange);
        } else if (ExchangeHelper.isOutCapable(exchange)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing body : " + body);
            }
            this.latch = new CountDownLatch(1);
            WriteFuture future = this.session.write(body);
            future.join();
            if (!future.isWritten()) {
                throw new RuntimeException("Timed out waiting for response: " + exchange);
            }
            this.latch.await(10000L, TimeUnit.MILLISECONDS);
            if (this.latch.getCount() == 1L) {
                throw new RuntimeException("No response from server within 10000 millisecs");
            }
            ResponseHandler handler = (ResponseHandler)this.session.getHandler();
            if (handler.getCause() != null) {
                throw new Exception("Response Handler had an exception", handler.getCause());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handler message: " + handler.getMessage());
            }
            exchange.getOut().setBody(handler.getMessage());
        } else {
            this.session.write(body);
        }
    }

    protected void doStart() throws Exception {
        SocketAddress address = this.endpoint.getAddress();
        IoConnector connector = this.endpoint.getConnector();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: " + address + " using connector: " + connector);
        }
        ResponseHandler ioHandler = new ResponseHandler(this.endpoint);
        ConnectFuture future = connector.connect(address, (IoHandler)ioHandler, this.endpoint.getConfig());
        future.join();
        this.session = future.getSession();
    }

    protected void doStop() throws Exception {
        if (this.session != null) {
            this.session.close().join(2000L);
        }
    }

    private final class ResponseHandler
    extends IoHandlerAdapter {
        private MinaEndpoint endpoint;
        private Object message;
        private Throwable cause;

        private ResponseHandler(MinaEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void messageReceived(IoSession ioSession, Object message) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message received: " + message);
            }
            this.cause = null;
            this.message = message;
            MinaProducer.this.latch.countDown();
        }

        public void exceptionCaught(IoSession ioSession, Throwable cause) {
            LOG.error("Exception on receiving message from address: " + this.endpoint.getAddress() + " using connector: " + this.endpoint.getConnector(), cause);
            this.message = null;
            this.cause = cause;
            ioSession.close();
            MinaProducer.this.latch.countDown();
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object getMessage() {
            return this.message;
        }
    }
}

