/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import org.apache.camel.Exchange;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;

public class IBatisProducer
extends DefaultProducer {
    private SqlMapClient sqlClient;
    private final IBatisEndpoint endpoint;

    public IBatisProducer(IBatisEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public IBatisEndpoint getEndpoint() {
        return (IBatisEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.sqlClient == null) {
            this.sqlClient = this.endpoint.getSqlClient();
        }
        Object body = ExchangeHelper.getMandatoryInBody(exchange);
        String operation = this.getOperationName(exchange);
        this.sqlClient.insert(operation, body);
    }

    protected String getOperationName(Exchange exchange) {
        return this.endpoint.getEntityName();
    }
}

