/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.logging.Logger;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.camel.component.cxf.interceptors.PayloadInInterceptor;
import org.apache.camel.component.cxf.interceptors.SoapMessageInInterceptor;
import org.apache.camel.component.cxf.interceptors.XMLMessageInInterceptor;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(DOMOutInterceptor.class);
    private final XMLMessageInInterceptor xmlInterceptor = new XMLMessageInInterceptor();
    private final SoapMessageInInterceptor soapInterceptor = new SoapMessageInInterceptor();

    public DOMInInterceptor() {
        super("read");
        this.addAfter(SoapActionInInterceptor.class.getName());
        this.addBefore(PayloadInInterceptor.class.getName());
    }

    public boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }

    public void handleMessage(Message message) throws Fault {
        if (message instanceof XMLMessage) {
            this.xmlInterceptor.handleMessage((XMLMessage)message);
        } else if (message instanceof SoapMessage) {
            this.soapInterceptor.handleMessage((SoapMessage)message);
        } else {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NOT_SUPPORTED_MESSAGE", LOG, new Object[]{message.getClass().getName()}));
        }
    }
}

