/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.AsyncProcessorDecorator;
import org.apache.camel.component.cxf.CxfSoapEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

public class CxfSoapConsumer
implements Consumer {
    private static final Log LOG = LogFactory.getLog(CxfSoapConsumer.class);
    private final CxfSoapEndpoint endpoint;
    private final Consumer consumer;
    private EndpointImpl ep;
    private MessageObserver chain;
    private Server server;

    public CxfSoapConsumer(CxfSoapEndpoint endpoint, Processor processor) throws Exception {
        this.endpoint = endpoint;
        AsyncProcessorDecorator soapProcessor = new AsyncProcessorDecorator(processor, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapConsumer.this.processSoapConsumerIn(exchange);
            }
        }, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapConsumer.this.processSoapConsumerOut(exchange);
            }
        });
        this.consumer = endpoint.getInnerEndpoint().createConsumer(soapProcessor);
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), endpoint.getDefinition(), endpoint.getService());
        Service cxfService = factory.create();
        EndpointInfo ei = (EndpointInfo)((ServiceInfo)cxfService.getServiceInfos().iterator().next()).getEndpoints().iterator().next();
        ei.setAddress("local://" + ei.getService().getName().toString() + "/" + ei.getName().getLocalPart());
        ei.getBinding().setProperty("databinding.disabled", (Object)Boolean.TRUE);
        cxfService.getInInterceptors().add(new ReadHeadersInterceptor(this.getBus()));
        cxfService.getInInterceptors().add(new MustUnderstandInterceptor());
        cxfService.getInInterceptors().add(new AttachmentInInterceptor());
        cxfService.getInInterceptors().add(new StaxInInterceptor());
        cxfService.getInInterceptors().add(new ReadHeadersInterceptor(this.getBus()));
        this.ep = new EndpointImpl(this.getBus(), cxfService, ei);
        this.chain = new ChainInitiationObserver((Endpoint)this.ep, this.getBus());
        this.server = new ServerImpl(this.getBus(), (Endpoint)this.ep, null, this.chain);
    }

    public void start() throws Exception {
        this.server.start();
        this.consumer.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.consumer.stop();
    }

    protected Bus getBus() {
        return this.endpoint.getBus();
    }

    protected void processSoapConsumerIn(Exchange exchange) throws Exception {
        LOG.info("processSoapConsumerIn: " + exchange);
    }

    protected void processSoapConsumerOut(Exchange exchange) throws Exception {
        LOG.info("processSoapConsumerOut: " + exchange);
    }
}

