/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CamelInvoker;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessageObserver;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfConsumer
extends DefaultConsumer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Server server;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        this.endpoint = endpoint;
        try {
            Bus bus = BusFactory.getDefaultBus();
            ServerFactoryBean svrBean = null;
            if (endpoint.isSpringContextEndpoint()) {
                CxfEndpointBean endpointBean = endpoint.getCxfEndpointBean();
                svrBean = CxfEndpointUtils.getServerFactoryBean(endpointBean.getServiceClass());
                endpoint.configure(svrBean);
                CxfEndpointBean cxfEndpointBean = endpoint.getCxfEndpointBean();
                if (cxfEndpointBean.getServiceName() != null) {
                    svrBean.getServiceFactory().setServiceName(cxfEndpointBean.getServiceName());
                }
                if (cxfEndpointBean.getEndpointName() != null) {
                    svrBean.getServiceFactory().setEndpointName(cxfEndpointBean.getEndpointName());
                }
            } else {
                Class serviceClass = ClassLoaderUtils.loadClass((String)endpoint.getServiceClass(), this.getClass());
                svrBean = CxfEndpointUtils.getServerFactoryBean(serviceClass);
                svrBean.setAddress(endpoint.getAddress());
                svrBean.setServiceClass(serviceClass);
                if (endpoint.getServiceName() != null) {
                    svrBean.getServiceFactory().setServiceName(CxfEndpointUtils.getServiceName(endpoint));
                }
                if (endpoint.getPortName() != null) {
                    svrBean.getServiceFactory().setEndpointName(CxfEndpointUtils.getPortName(endpoint));
                }
                if (endpoint.getWsdlURL() != null) {
                    svrBean.setWsdlURL(endpoint.getWsdlURL());
                }
            }
            DataFormat dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
            if (dataFormat.equals((Object)DataFormat.POJO)) {
                svrBean.setInvoker((Invoker)new CamelInvoker(this));
            }
            svrBean.setBus(bus);
            svrBean.setStart(false);
            this.server = svrBean.create();
            if (!dataFormat.equals((Object)DataFormat.POJO)) {
                CxfMessageObserver observer = new CxfMessageObserver(this, this.server.getEndpoint(), bus, dataFormat);
                ServerImpl serverImpl = (ServerImpl)this.server;
                serverImpl.setMessageObserver((MessageObserver)observer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.server.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.server.stop();
        super.doStop();
    }

    public CxfEndpoint getEndpoint() {
        return this.endpoint;
    }
}

