/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.NoFactoryAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryFinder {
    private final String path;
    private final ConcurrentHashMap classMap = new ConcurrentHashMap();

    public FactoryFinder() {
        this("META-INF/services/org/apache/camel/");
    }

    public FactoryFinder(String path) {
        this.path = path;
    }

    public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        return this.newInstance(key, (String)null);
    }

    public Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz = this.findClass(key, propertyPrefix);
        return clazz.newInstance();
    }

    public Object newInstance(String key, Injector injector) throws IOException, ClassNotFoundException {
        return this.newInstance(key, injector, (String)null);
    }

    public Object newInstance(String key, Injector injector, String propertyPrefix) throws IOException, ClassNotFoundException {
        Class type = this.findClass(key, propertyPrefix);
        return injector.newInstance(type);
    }

    public <T> T newInstance(String key, Injector injector, Class<T> expectedType) throws IOException, ClassNotFoundException {
        return this.newInstance(key, injector, null, expectedType);
    }

    public <T> T newInstance(String key, Injector injector, String propertyPrefix, Class<T> expectedType) throws IOException, ClassNotFoundException {
        Class type = this.findClass(key, propertyPrefix);
        Object value = injector.newInstance(type);
        if (expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        throw new ClassCastException("Not instanceof " + expectedType.getName() + " value: " + value);
    }

    public <T> List<T> newInstances(String key, Injector injector, Class<T> type) throws IOException, ClassNotFoundException {
        List<Class> list = this.findClasses(key);
        ArrayList<T> answer = new ArrayList<T>(list.size());
        answer.add(this.newInstance(key, injector, type));
        return answer;
    }

    public Class findClass(String key) throws ClassNotFoundException, IOException {
        return this.findClass(key, null);
    }

    public Class findClass(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class clazz;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        if ((clazz = (Class)this.classMap.get(propertyPrefix + key)) == null) {
            clazz = this.newInstance(this.doFindFactoryProperies(key), propertyPrefix);
            this.classMap.put(propertyPrefix + key, clazz);
        }
        return clazz;
    }

    public List<Class> findClasses(String key) throws ClassNotFoundException, IOException {
        return this.findClasses(key, null);
    }

    public List<Class> findClasses(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class type = this.findClass(key, propertyPrefix);
        return Collections.singletonList(type);
    }

    private Class newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, IOException {
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clazz = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = FactoryFinder.class.getClassLoader().loadClass(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties doFindFactoryProperies(String key) throws IOException {
        InputStream in;
        String uri = this.path + key;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((in = classLoader.getResourceAsStream(uri)) == null && (in = FactoryFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
            throw new NoFactoryAvailableException(uri);
        }
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ignore) {}
        }
    }
}

