/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.spring.handler.ScriptDefinitionParser;
import org.apache.camel.spring.remoting.CamelProxyFactoryBean;
import org.apache.camel.spring.remoting.CamelServiceExporter;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String JAXB_PACKAGES = "org.apache.camel.spring:org.apache.camel.model:org.apache.camel.model.language";
    protected BeanDefinitionParser endpointParser = new BeanDefinitionParser(EndpointFactoryBean.class);
    protected BeanDefinitionParser proxyParser = new BeanDefinitionParser(CamelProxyFactoryBean.class);
    protected BeanDefinitionParser exportParser = new BeanDefinitionParser(CamelServiceExporter.class);
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class);
    protected Set<String> parserElementNames = new HashSet<String>();
    private JAXBContext jaxbContext;

    public void init() {
        this.registerParser("endpoint", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.endpointParser);
        this.registerParser("proxy", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.proxyParser);
        this.registerParser("export", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.exportParser);
        this.registerParser("camelContext", (org.springframework.beans.factory.xml.BeanDefinitionParser)new BeanDefinitionParser(CamelContextFactoryBean.class){

            protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
                Object value;
                super.doParse(element, parserContext, builder);
                String contextId = element.getAttribute("id");
                if (ObjectHelper.isNullOrBlank(contextId)) {
                    contextId = "camelContext";
                    element.setAttribute("id", contextId);
                }
                if ((value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext)) instanceof CamelContextFactoryBean) {
                    CamelContextFactoryBean factoryBean = (CamelContextFactoryBean)value;
                    builder.addPropertyValue("routes", factoryBean.getRoutes());
                    if (factoryBean.getPackages().length > 0) {
                        builder.addPropertyValue("packages", (Object)factoryBean.getPackages());
                    }
                }
                boolean createdBeanPostProcessor = false;
                NodeList list = element.getChildNodes();
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    String id;
                    BeanDefinition definition;
                    Node child = list.item(i);
                    if (!(child instanceof Element)) continue;
                    Element childElement = (Element)child;
                    String localName = child.getLocalName();
                    if (localName.equals("beanPostProcessor")) {
                        CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement);
                        createdBeanPostProcessor = true;
                        continue;
                    }
                    if (localName.equals("endpoint")) {
                        definition = CamelNamespaceHandler.this.endpointParser.parse(childElement, parserContext);
                        id = childElement.getAttribute("id");
                        if (!ObjectHelper.isNotNullAndNonEmpty(id)) continue;
                        definition.getPropertyValues().addPropertyValue("context", (Object)new RuntimeBeanReference(contextId));
                        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                        continue;
                    }
                    if (localName.equals("proxy")) {
                        definition = CamelNamespaceHandler.this.proxyParser.parse(childElement, parserContext);
                        id = childElement.getAttribute("id");
                        if (!ObjectHelper.isNotNullAndNonEmpty(id)) continue;
                        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                        continue;
                    }
                    if (!localName.equals("export")) continue;
                    definition = CamelNamespaceHandler.this.exportParser.parse(childElement, parserContext);
                    id = childElement.getAttribute("id");
                    if (!ObjectHelper.isNotNullAndNonEmpty(id)) continue;
                    parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                }
                if (!createdBeanPostProcessor) {
                    Element childElement = element.getOwnerDocument().createElement("beanPostProcessor");
                    element.appendChild(childElement);
                    CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement);
                }
            }
        });
        this.registerParser("xpath", (org.springframework.beans.factory.xml.BeanDefinitionParser)new BeanDefinitionParser(XPathBuilder.class){

            protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
                String xpath = DomUtils.getTextValue((Element)element);
                builder.addConstructorArg((Object)xpath);
                super.doParse(element, parserContext, builder);
                builder.addPropertyValue("namespacesFromDom", (Object)element);
            }
        });
    }

    protected void createBeanPostProcessor(ParserContext parserContext, String contextId, Element childElement) {
        String beanPostProcessorId = contextId + ":beanPostProcessor";
        childElement.setAttribute("id", beanPostProcessorId);
        BeanDefinition definition = this.beanPostProcessorParser.parse(childElement, parserContext);
        definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
    }

    protected void registerScriptParser(String elementName, String engineName) {
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)new ScriptDefinitionParser(engineName));
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    public Set<String> getParserElementNames() {
        return this.parserElementNames;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext) {
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            return unmarshaller.unmarshal((Node)element);
        }
        catch (JAXBException e) {
            throw new BeanDefinitionStoreException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGES);
        }
        return this.jaxbContext;
    }
}

