/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.impl.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main
extends ServiceSupport {
    private static final Log LOG = LogFactory.getLog(Main.class);
    private String applicationContextUri = "META-INF/spring/*.xml";
    private AbstractApplicationContext applicationContext;
    private List<Option> options = new ArrayList<Option>();
    private CountDownLatch latch = new CountDownLatch(1);
    private AtomicBoolean completed = new AtomicBoolean(false);

    public Main() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.showOptions();
                Main.this.completed();
            }
        });
        this.addOption(new ParameterOption("a", "applicationContext", "Sets the classpath based pring ApplicationContext", "applicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.run();
    }

    public void run() {
        if (!this.completed.get()) {
            try {
                this.start();
                this.waitUntilCompleted();
                this.stop();
            }
            catch (Exception e) {
                LOG.error("Failed: " + e, e);
            }
        }
    }

    public void completed() {
        this.completed.set(true);
        this.latch.countDown();
    }

    public void showOptions() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
        for (Option option : this.options) {
            System.out.println("  " + option.getAbbreviation() + " or " + option.getFullName() + " = " + option.getDescription());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    protected void doStart() throws Exception {
        LOG.info("Apache Camel " + this.getVersion() + " starting");
        if (this.applicationContext == null) {
            this.applicationContext = this.createDefaultApplicationContext();
        }
        this.applicationContext.start();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        return new ClassPathXmlApplicationContext(this.getApplicationContextUri());
    }

    protected void doStop() throws Exception {
        LOG.info("Apache Camel terminating");
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected String getVersion() {
        Package aPackage = Package.getPackage("org.apache.camel");
        if (aPackage != null) {
            String version = aPackage.getImplementationVersion();
            if (version == null && (version = aPackage.getSpecificationVersion()) == null) {
                version = "";
            }
            return version;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                Main.this.showOptions();
                Main.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

