/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.ErrorHandler;

public abstract class ErrorHandlerSupport
extends ServiceSupport
implements ErrorHandler {
    private Map<Class, ExceptionType> exceptionPolicices = new IdentityHashMap<Class, ExceptionType>();

    public void addExceptionPolicy(ExceptionType exception) {
        Processor processor = exception.getErrorHandler();
        this.addChildService(processor);
        List<Class> list = exception.getExceptionClasses();
        for (Class exceptionType : list) {
            this.exceptionPolicices.put(exceptionType, exception);
        }
    }

    protected boolean customProcessorForException(Exchange exchange, Throwable exception) throws Exception {
        ExceptionType policy = this.getExceptionPolicy(exchange, exception);
        Processor processor = policy.getErrorHandler();
        if (processor != null) {
            processor.process(exchange);
            return true;
        }
        return false;
    }

    protected ExceptionType getExceptionPolicy(Exchange exchange, Throwable exception) {
        Set<Map.Entry<Class, ExceptionType>> entries = this.exceptionPolicices.entrySet();
        for (Map.Entry<Class, ExceptionType> entry : entries) {
            Class type = entry.getKey();
            if (!type.isInstance(exception)) continue;
            return entry.getValue();
        }
        return null;
    }
}

