/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.FromType;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.SendProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="to")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToType
extends ProcessorType {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String ref;
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlTransient
    private Endpoint endpoint;

    public ToType() {
    }

    public ToType(String uri) {
        this.setUri(uri);
    }

    public ToType(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    public String toString() {
        return "To[" + FromType.description(this.getUri(), this.getRef(), this.getEndpoint()) + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        return new SendProcessor(endpoint);
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            this.endpoint = context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public List<ProcessorType> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }
}

