/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.WhenType;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="choice")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChoiceType
extends ProcessorType {
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlElementRef
    private List<WhenType> whenClauses = new ArrayList<WhenType>();
    @XmlElement(required=false)
    private OtherwiseType otherwise;

    public String toString() {
        return "Choice[ " + this.getWhenClauses() + " " + this.getOtherwise() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenType whenClaus : this.whenClauses) {
            filters.add(whenClaus.createProcessor(routeContext));
        }
        Processor otherwiseProcessor = null;
        if (this.otherwise != null) {
            otherwiseProcessor = this.otherwise.createProcessor(routeContext);
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    public ChoiceType when(Predicate predicate) {
        this.getWhenClauses().add(new WhenType(predicate));
        return this;
    }

    public OtherwiseType otherwise() {
        OtherwiseType answer = new OtherwiseType();
        this.setOtherwise(answer);
        return answer;
    }

    @Override
    public ChoiceType proceed() {
        super.proceed();
        return this;
    }

    @Override
    public ChoiceType to(Endpoint endpoint) {
        super.to(endpoint);
        return this;
    }

    @Override
    public ChoiceType to(Collection<Endpoint> endpoints) {
        super.to(endpoints);
        return this;
    }

    @Override
    public ChoiceType to(Endpoint ... endpoints) {
        super.to(endpoints);
        return this;
    }

    @Override
    public ChoiceType to(String uri) {
        super.to(uri);
        return this;
    }

    @Override
    public ChoiceType to(String ... uris) {
        super.to(uris);
        return this;
    }

    public List<WhenType> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenType> whenClauses) {
        this.whenClauses = whenClauses;
    }

    @Override
    public List<ProcessorType> getOutputs() {
        if (this.otherwise != null) {
            return this.otherwise.getOutputs();
        }
        if (this.whenClauses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        WhenType when = this.whenClauses.get(this.whenClauses.size() - 1);
        return when.getOutputs();
    }

    public OtherwiseType getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(OtherwiseType otherwise) {
        this.otherwise = otherwise;
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }
}

