/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;

public class CamelNamingStrategy {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String KEY_CONTEXT = "context";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_ROUTE = "route";
    public static final String KEY_TYPE = "type";
    public static final String KEY_NAME = "name";
    public static final String TYPE_ENDPOINTS = "Endpoints";
    public static final String TYPE_SERVICES = "Services";
    public static final String TYPE_ROUTES = "Routes";
    protected String domainName = "org.apache.camel";
    protected String hostName = "locahost";

    public CamelNamingStrategy(String domainName) {
        if (domainName != null) {
            this.domainName = domainName;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public ObjectName getObjectName(CamelContext context) throws MalformedObjectNameException {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put(KEY_CONTEXT, this.getContextId(context));
        keys.put(KEY_NAME, "camel");
        return new ObjectName(this.domainName, keys);
    }

    public ObjectName getObjectName(ManagedEndpoint mbean) throws MalformedObjectNameException {
        Endpoint ep = mbean.getEndpoint();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put(KEY_CONTEXT, this.getContextId(ep.getContext()));
        keys.put(KEY_TYPE, TYPE_ENDPOINTS);
        keys.put(KEY_ENDPOINT, this.getEndpointId(ep));
        return new ObjectName(this.domainName, keys);
    }

    public ObjectName getObjectName(CamelContext context, ManagedService mbean) throws MalformedObjectNameException {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put(KEY_CONTEXT, this.getContextId(context));
        keys.put(KEY_TYPE, TYPE_SERVICES);
        keys.put(KEY_ENDPOINT, Integer.toHexString(mbean.getService().hashCode()));
        return new ObjectName(this.domainName, keys);
    }

    public ObjectName getObjectName(ManagedRoute mbean) throws MalformedObjectNameException {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        Endpoint ep = mbean.getRoute().getEndpoint();
        String ctxid = ep != null ? this.getContextId(ep.getContext()) : VALUE_UNKNOWN;
        keys.put(KEY_CONTEXT, ctxid);
        keys.put(KEY_TYPE, TYPE_ROUTES);
        keys.put(KEY_ENDPOINT, this.getEndpointId(ep));
        return new ObjectName(this.domainName, keys);
    }

    protected String getContextId(CamelContext context) {
        String id = context != null ? Integer.toString(context.hashCode()) : VALUE_UNKNOWN;
        return this.hostName + "/" + id;
    }

    protected String getEndpointId(Endpoint ep) {
        String id;
        String uri = ep.getEndpointUri();
        int pos = uri.indexOf(58);
        String string = id = pos == -1 ? uri : "[" + uri.substring(0, pos) + "]" + uri.substring(pos + 1);
        if (!ep.isSingleton()) {
            id = id + "." + Integer.toString(ep.hashCode());
        }
        return id;
    }
}

