/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultMessage;
import org.jivesoftware.smack.packet.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppMessage
extends DefaultMessage {
    private Message xmppMessage;

    public XmppMessage() {
        this(new Message());
    }

    public XmppMessage(Message jmsMessage) {
        this.xmppMessage = jmsMessage;
    }

    @Override
    public String toString() {
        if (this.xmppMessage != null) {
            return "XmppMessage: " + this.xmppMessage;
        }
        return "XmppMessage: " + this.getBody();
    }

    @Override
    public XmppExchange getExchange() {
        return (XmppExchange)super.getExchange();
    }

    public Message getXmppMessage() {
        return this.xmppMessage;
    }

    public void setXmppMessage(Message xmppMessage) {
        this.xmppMessage = xmppMessage;
    }

    @Override
    public Object getHeader(String name) {
        return this.xmppMessage.getProperty(name);
    }

    @Override
    public void setHeader(String name, Object value) {
        if (value == null) {
            this.xmppMessage.deleteProperty(name);
        } else {
            this.xmppMessage.setProperty(name, value);
        }
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Iterator iter = this.xmppMessage.getPropertyNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            answer.put(name, this.xmppMessage.getProperty(name));
        }
        return answer;
    }

    @Override
    public XmppMessage newInstance() {
        return new XmppMessage();
    }

    @Override
    protected Object createBody() {
        if (this.xmppMessage != null) {
            return this.getExchange().getBinding().extractBodyFromXmpp(this.getExchange(), this.xmppMessage);
        }
        return null;
    }
}

