/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.rmi.RmiEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class RmiProducer
extends DefaultProducer {
    private final RmiEndpoint endpoint;
    private Remote remote;
    private BeanProcessor beanProcessor;

    public RmiProducer(RmiEndpoint endpoint) throws RemoteException, NotBoundException {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.beanProcessor == null) {
            this.beanProcessor = new BeanProcessor((Object)this.getRemote(), this.getEndpoint().getContext());
        }
        this.beanProcessor.process(exchange);
    }

    public Remote getRemote() throws RemoteException, NotBoundException {
        if (this.remote == null) {
            Registry registry = this.endpoint.getRegistry();
            this.remote = registry.lookup(this.endpoint.getName());
        }
        return this.remote;
    }
}

