/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanExchange;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.rmi.RmiEndpoint;
import org.apache.camel.impl.DefaultConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiConsumer
extends DefaultConsumer<BeanExchange>
implements InvocationHandler {
    private final RmiEndpoint endpoint;
    private Remote stub;
    private Remote proxy;

    public RmiConsumer(RmiEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        Class[] interfaces = new Class[this.endpoint.getRemoteInterfaces().size()];
        this.endpoint.getRemoteInterfaces().toArray(interfaces);
        this.proxy = (Remote)Proxy.newProxyInstance(this.endpoint.getClassLoader(), interfaces, (InvocationHandler)this);
        this.stub = UnicastRemoteObject.exportObject(this.proxy, this.endpoint.getPort());
        try {
            Registry registry = this.endpoint.getRegistry();
            String name = this.endpoint.getName();
            registry.bind(name, this.stub);
        }
        catch (Exception e) {
            try {
                UnicastRemoteObject.unexportObject(this.stub, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stub = null;
            throw e;
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        try {
            Registry registry = this.endpoint.getRegistry();
            registry.unbind(this.endpoint.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnicastRemoteObject.unexportObject(this.proxy, true);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.isStarted()) {
            throw new IllegalStateException("The endpoint is not active: " + this.getEndpoint().getEndpointUri());
        }
        BeanInvocation invocation = new BeanInvocation(proxy, method, args);
        BeanExchange exchange = (BeanExchange)this.getEndpoint().createExchange();
        exchange.setInvocation(invocation);
        this.getProcessor().process(exchange);
        Throwable fault = exchange.getException();
        if (fault != null) {
            throw new InvocationTargetException(fault);
        }
        return exchange.getOut().getBody();
    }

    public Remote getProxy() {
        return this.proxy;
    }

    public Remote getStub() {
        return this.stub;
    }
}

