/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.component.irc.IrcErrorLogger;
import org.apache.camel.component.irc.IrcExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcProducer
extends DefaultProducer<IrcExchange> {
    public static final String[] COMMANDS = new String[]{"AWAY", "INVITE", "ISON", "JOIN", "KICK", "LIST", "NAMES", "PRIVMSG", "MODE", "NICK", "NOTICE", "PART", "PONG", "QUIT", "TOPIC", "WHO", "WHOIS", "WHOWAS", "USERHOST"};
    private static final transient Log LOG = LogFactory.getLog(IrcProducer.class);
    private IRCConnection connection;
    private IrcEndpoint endpoint;
    private IRCEventListener ircErrorLogger;

    public IrcProducer(IrcEndpoint endpoint, IRCConnection connection) {
        super(endpoint);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        try {
            String msg = exchange.getIn().getBody(String.class);
            if (this.isMessageACommand(msg)) {
                this.connection.send(msg);
            } else {
                String target = this.endpoint.getConfiguration().getTarget();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending to: " + target + " message: " + msg);
                }
                this.connection.doPrivmsg(target, msg);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.ircErrorLogger = this.createIrcErrorLogger();
        this.connection.addIRCEventListener(this.ircErrorLogger);
        String target = this.endpoint.getConfiguration().getTarget();
        LOG.debug("joining: " + target);
        this.connection.doJoin(target);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.connection != null) {
            this.connection.removeIRCEventListener(this.ircErrorLogger);
        }
    }

    protected boolean isMessageACommand(String msg) {
        for (String command : COMMANDS) {
            if (!msg.startsWith(command)) continue;
            return true;
        }
        return false;
    }

    protected IRCEventListener createIrcErrorLogger() {
        return new IrcErrorLogger(LOG);
    }
}

