/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.FileProcessStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends ScheduledPollConsumer<FileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FileConsumer.class);
    private final FileEndpoint endpoint;
    private boolean recursive = true;
    private String regexPattern = "";
    private long lastPollTime;

    public FileConsumer(FileEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void poll() throws Exception {
        this.pollFileOrDirectory(this.endpoint.getFile(), this.isRecursive());
        this.lastPollTime = System.currentTimeMillis();
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            if (this.isValidFile(fileOrDirectory)) {
                LOG.debug("Polling directory " + fileOrDirectory);
                File[] files = fileOrDirectory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.pollFileOrDirectory(files[i], this.isRecursive());
                }
            }
        } else {
            LOG.debug("Skipping directory " + fileOrDirectory);
        }
    }

    protected void pollFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (this.isValidFile(file)) {
            long fileModified;
            if (this.endpoint.isNoop() && (fileModified = file.lastModified()) <= this.lastPollTime) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring file: " + file + " as modified time: " + fileModified + " less than last poll time: " + this.lastPollTime);
                }
                return;
            }
            FileProcessStrategy processStrategy = this.endpoint.getFileStrategy();
            FileExchange exchange = this.endpoint.createExchange(file);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("About to process file:  " + file + " using exchange: " + exchange);
                }
                if (processStrategy.begin(this.endpoint, exchange, file)) {
                    this.getProcessor().process(exchange);
                    processStrategy.commit(this.endpoint, exchange, file);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(this.endpoint + " cannot process file: " + file);
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    protected boolean isValidFile(File file) {
        boolean result = false;
        if (file != null && file.exists() && this.isMatched(file)) {
            result = true;
        }
        return result;
    }

    protected boolean isMatched(File file) {
        String[] postfixes;
        String name = file.getName();
        if (this.regexPattern != null && this.regexPattern.length() > 0 && !name.matches(this.getRegexPattern())) {
            return false;
        }
        String[] prefixes = this.endpoint.getExcludedNamePrefixes();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
        }
        if ((postfixes = this.endpoint.getExcludedNamePostfixes()) != null) {
            for (String postfix : postfixes) {
                if (!name.endsWith(postfix)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

