/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Properties;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfInvokeComponent;
import org.apache.camel.component.cxf.CxfInvokeConsumer;
import org.apache.camel.component.cxf.CxfInvokeProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfInvokeEndpoint
extends DefaultEndpoint<CxfExchange> {
    private CxfBinding binding;
    private final CxfInvokeComponent component;
    private boolean inOut = true;
    private Properties properties;

    public CxfInvokeEndpoint(String uri, CxfInvokeComponent component, Properties properties) {
        super(uri, component);
        this.component = component;
        this.properties = properties;
    }

    @Override
    public Producer<CxfExchange> createProducer() throws Exception {
        return new CxfInvokeProducer(this);
    }

    @Override
    public Consumer<CxfExchange> createConsumer(Processor processor) throws Exception {
        return new CxfInvokeConsumer(this, processor);
    }

    @Override
    public CxfExchange createExchange() {
        return new CxfExchange(this.getContext(), this.getBinding());
    }

    public CxfExchange createExchange(Message inMessage) {
        return new CxfExchange(this.getContext(), this.getBinding(), inMessage);
    }

    public CxfBinding getBinding() {
        if (this.binding == null) {
            this.binding = new CxfBinding();
        }
        return this.binding;
    }

    public void setBinding(CxfBinding binding) {
        this.binding = binding;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    @Override
    public CxfInvokeComponent getComponent() {
        return this.component;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Bus getBus() {
        return this.component.getBus();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

