/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfInvokeEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfInvokeConsumer
extends DefaultConsumer<CxfExchange> {
    protected CxfInvokeEndpoint cxfEndpoint;
    private ServerImpl server;

    public CxfInvokeConsumer(CxfInvokeEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.cxfEndpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.server != null) {
            ServerFactoryBean svrBean = new ServerFactoryBean();
            svrBean.setAddress(this.getEndpoint().getEndpointUri());
            svrBean.setServiceClass(Class.forName(this.cxfEndpoint.getProperty("impl")));
            svrBean.setBus(this.cxfEndpoint.getBus());
            this.server = (ServerImpl)svrBean.create();
            this.server.start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        super.doStop();
    }

    protected void incomingCxfMessage(Message message) {
        try {
            CxfExchange exchange = this.cxfEndpoint.createExchange(message);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

