/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.local.LocalTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfConsumer
extends DefaultConsumer<CxfExchange> {
    private CxfEndpoint endpoint;
    private final LocalTransportFactory transportFactory;
    private Destination destination;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor, LocalTransportFactory transportFactory) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.transportFactory = transportFactory;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.destination = this.transportFactory.getDestination(this.endpoint.getEndpointInfo());
        this.destination.setMessageObserver(new MessageObserver(){

            public void onMessage(Message message) {
                CxfConsumer.this.incomingCxfMessage(message);
            }
        });
    }

    @Override
    protected void doStop() throws Exception {
        if (this.destination != null) {
            this.destination.shutdown();
        }
        super.doStop();
    }

    protected void incomingCxfMessage(Message message) {
        try {
            CxfExchange exchange = this.endpoint.createExchange(message);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

