/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.RoutesType;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RouteBuilder
extends BuilderSupport {
    private AtomicBoolean initalized = new AtomicBoolean(false);
    private RoutesType routeCollection = new RoutesType();
    private List<Route> routes = new ArrayList<Route>();

    protected RouteBuilder() {
        this((CamelContext)null);
    }

    protected RouteBuilder(CamelContext context) {
        super(context);
    }

    public abstract void configure() throws Exception;

    public RouteType from(String uri) {
        return this.routeCollection.from(uri);
    }

    public RouteType from(Endpoint endpoint) {
        return this.routeCollection.from(endpoint);
    }

    public RouteBuilder errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return this;
    }

    public RouteBuilder inheritErrorHandler(boolean value) {
        this.routeCollection.setInheritErrorHandlerFlag(value);
        return this;
    }

    public RouteBuilder intercept(DelegateProcessor interceptor) {
        this.routeCollection.intercept(interceptor);
        return this;
    }

    public InterceptType intercept() {
        return this.routeCollection.intercept();
    }

    public OtherwiseType intercept(Predicate predicate) {
        return this.routeCollection.intercept(predicate);
    }

    public ExceptionType exception(Class exceptionType) {
        return this.routeCollection.exception(exceptionType);
    }

    @Override
    public CamelContext getContext() {
        CamelContext context = super.getContext();
        if (context == null) {
            context = this.createContainer();
            this.setContext(context);
        }
        return context;
    }

    public List<Route> getRouteList() throws Exception {
        this.checkInitialized();
        return this.routes;
    }

    protected void checkInitialized() throws Exception {
        if (this.initalized.compareAndSet(false, true)) {
            this.configure();
            this.populateRoutes(this.routes);
        }
    }

    protected void populateRoutes(List<Route> routes) throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("No CamelContext has been injected!");
        }
        this.routeCollection.setCamelContext(camelContext);
        this.routeCollection.populateRoutes(routes);
    }

    protected CamelContext createContainer() {
        return new DefaultCamelContext();
    }
}

