/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.camel.Body;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Property;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spring.util.MethodInfo;
import org.apache.camel.spring.util.MethodInvocationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfo {
    private static final transient Log log = LogFactory.getLog(BeanInfo.class);
    private Class type;
    private MethodInvocationStrategy strategy;
    private Map<String, MethodInfo> operations = new ConcurrentHashMap<String, MethodInfo>();
    private MethodInfo defaultExpression;

    public BeanInfo(Class type, MethodInvocationStrategy strategy) {
        this.type = type;
        this.strategy = strategy;
    }

    public Class getType() {
        return this.type;
    }

    public void introspect() {
        this.introspect(this.getType());
        if (this.operations.size() == 1) {
            Collection<MethodInfo> methodInfos = this.operations.values();
            Iterator<MethodInfo> i$ = methodInfos.iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo;
                this.defaultExpression = methodInfo = i$.next();
            }
        }
    }

    public MethodInvocation createInvocation(Method method, Object pojo, Exchange messageExchange) throws RuntimeCamelException {
        MethodInfo methodInfo = this.introspect(this.type, method);
        return methodInfo.createMethodInvocation(pojo, messageExchange);
    }

    public MethodInvocation createInvocation(Object pojo, Exchange messageExchange) throws RuntimeCamelException {
        MethodInfo methodInfo = null;
        String name = messageExchange.getIn().getHeader("org.apache.camel.MethodName", String.class);
        if (name != null) {
            methodInfo = this.operations.get(name);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultExpression;
        }
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, messageExchange);
        }
        return null;
    }

    protected void introspect(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.introspect(clazz, method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected MethodInfo introspect(Class clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Expression[] parameterExpressions = new Expression[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations[i]);
            if (expression == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No expression available for method: " + method.toString() + " parameter: " + i + " so ignoring method"));
                }
                if (parameterTypes.length == 1) {
                    expression = ExpressionBuilder.bodyExpression(parameterType);
                } else {
                    return null;
                }
            }
            parameterExpressions[i] = expression;
        }
        String opName = method.getName();
        Expression parametersExpression = this.createMethodParametersExpression(parameterExpressions);
        MethodInfo methodInfo = new MethodInfo(clazz, method, parametersExpression);
        this.operations.put(opName, methodInfo);
        return methodInfo;
    }

    protected Expression createMethodParametersExpression(final Expression[] parameterExpressions) {
        return new Expression<Exchange>(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object[] answer = new Object[parameterExpressions.length];
                for (int i = 0; i < parameterExpressions.length; ++i) {
                    Expression parameterExpression = parameterExpressions[i];
                    answer[i] = parameterExpression.evaluate(exchange);
                }
                return answer;
            }

            public String toString() {
                return "parametersExpression" + Arrays.asList(parameterExpressions);
            }
        };
    }

    protected Expression createParameterUnmarshalExpression(Class clazz, Method method, Class parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    protected Expression createParameterUnmarshalExpressionForAnnotation(Class clazz, Method method, Class parameterType, Annotation annotation) {
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.propertyExpression(propertyAnnotation.name());
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression(headerAnnotation.name());
        }
        if (annotation instanceof Body) {
            Body content = (Body)annotation;
            return ExpressionBuilder.bodyExpression(parameterType);
        }
        return null;
    }
}

