/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pojo.timer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.camel.Processor;
import org.apache.camel.component.pojo.PojoExchange;
import org.apache.camel.component.pojo.PojoInvocation;
import org.apache.camel.component.pojo.timer.TimerComponent;
import org.apache.camel.component.pojo.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerConsumer
extends DefaultConsumer<PojoExchange>
implements InvocationHandler {
    private final TimerEndpoint endpoint;
    private Timer timer;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        TimerComponent component = this.endpoint.getComponent();
        component.addConsumer(this);
        this.timer = this.createTimerAndTask();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        TimerComponent component = this.endpoint.getComponent();
        component.removeConsumer(this);
    }

    private Timer createTimerAndTask() {
        final Runnable proxy = this.createProxy();
        TimerTask task = new TimerTask(){

            public void run() {
                proxy.run();
            }
        };
        Timer result = new Timer(this.endpoint.getTimerName(), this.endpoint.isDaemon());
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                result.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                result.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() >= 0L) {
                result.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                result.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() >= 0L) {
            result.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            result.schedule(task, this.endpoint.getDelay());
        }
        return result;
    }

    public Runnable createProxy() {
        return (Runnable)Proxy.newProxyInstance(Runnable.class.getClassLoader(), new Class[]{Runnable.class}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.isStarted()) {
            throw new IllegalStateException("The endpoint is not active: " + this.getEndpoint().getEndpointUri());
        }
        PojoInvocation invocation = new PojoInvocation(proxy, method, args);
        PojoExchange exchange = (PojoExchange)this.getEndpoint().createExchange();
        exchange.setInvocation(invocation);
        this.getProcessor().process(exchange);
        Throwable fault = exchange.getException();
        if (fault != null) {
            throw new InvocationTargetException(fault);
        }
        return exchange.getOut().getBody();
    }
}

