/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jbi.JbiBinding;
import org.apache.camel.component.jbi.JbiMessage;
import org.apache.camel.impl.DefaultExchange;

public class JbiExchange
extends DefaultExchange {
    private final JbiBinding binding;
    private MessageExchange messageExchange;

    public JbiExchange(CamelContext context, JbiBinding binding) {
        super(context);
        this.binding = binding;
    }

    public JbiExchange(CamelContext context, JbiBinding binding, MessageExchange messageExchange) {
        super(context);
        this.binding = binding;
        this.messageExchange = messageExchange;
        this.setIn(new JbiMessage(messageExchange.getMessage("in")));
        this.setOut(new JbiMessage(messageExchange.getMessage("out")));
        this.setFault(new JbiMessage(messageExchange.getMessage("fault")));
    }

    public JbiMessage getIn() {
        return (JbiMessage)super.getIn();
    }

    public JbiMessage getOut() {
        return (JbiMessage)super.getOut();
    }

    public JbiMessage getOut(boolean lazyCreate) {
        return (JbiMessage)super.getOut(lazyCreate);
    }

    public JbiMessage getFault() {
        return (JbiMessage)super.getFault();
    }

    public JbiBinding getBinding() {
        return this.binding;
    }

    public MessageExchange getMessageExchange() {
        return this.messageExchange;
    }

    public NormalizedMessage getInMessage() {
        return this.getIn().getNormalizedMessage();
    }

    public NormalizedMessage getOutMessage() {
        return this.getOut().getNormalizedMessage();
    }

    public NormalizedMessage getFaultMessage() {
        return this.getFault().getNormalizedMessage();
    }

    protected JbiMessage createInMessage() {
        return new JbiMessage();
    }

    protected JbiMessage createOutMessage() {
        return new JbiMessage();
    }
}

