/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.transport.CamelTransportBase;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class CamelConduit
extends AbstractConduit
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-conduit-base";
    private static final Logger LOG = LogUtils.getL7dLogger(CamelConduit.class);
    private final CamelTransportBase base;
    private String targetCamelEndpointUri;

    public CamelConduit(CamelContext camelContext, Bus bus, EndpointInfo endpointInfo, EndpointReferenceType targetReference) {
        super(targetReference);
        AttributedURIType address = targetReference.getAddress();
        if (address != null) {
            this.targetCamelEndpointUri = address.getValue();
        }
        this.base = new CamelTransportBase(camelContext, bus, endpointInfo, false, BASE_BEAN_NAME_SUFFIX);
        this.initConfig();
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "CamelConduit send message");
        message.setContent(OutputStream.class, (Object)new CamelOutputStream(message));
    }

    public void close() {
        this.getLogger().log(Level.FINE, "CamelConduit closed ");
        this.base.close();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public String getBeanName() {
        EndpointInfo info = this.base.endpointInfo;
        if (info == null) {
            return "default.camel-conduit";
        }
        return info.getName() + ".camel-conduit";
    }

    private void initConfig() {
        Configurer configurer = (Configurer)this.base.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)this);
        }
    }

    private boolean isTextPayload() {
        return true;
    }

    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        public synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class CamelOutputStream
    extends AbstractCachedOutputStream {
        private Message outMessage;
        private boolean isOneWay;

        public CamelOutputStream(Message m) {
            this.outMessage = m;
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.isOneWay = this.outMessage.getExchange().isOneWay();
            this.commitOutputMessage();
            if (!this.isOneWay) {
                this.handleResponse();
            }
        }

        protected void onWrite() throws IOException {
        }

        private void commitOutputMessage() {
            ((CamelConduit)CamelConduit.this).base.template.send(CamelConduit.this.targetCamelEndpointUri, new Processor(){

                public void process(Exchange reply) {
                    Object id;
                    Object request = null;
                    request = CamelConduit.this.isTextPayload() ? CamelOutputStream.this.currentStream.toString() : (Object)((ByteArrayOutputStream)CamelOutputStream.this.currentStream).toByteArray();
                    CamelConduit.this.getLogger().log(Level.FINE, "Conduit Request is :[" + request + "]");
                    String replyTo = CamelConduit.this.base.getReplyDestination();
                    CamelConduit.this.base.marshal(request, replyTo, reply);
                    CamelConduit.this.base.setMessageProperties(CamelOutputStream.this.outMessage, reply);
                    Object correlationID = null;
                    if (!CamelOutputStream.this.isOneWay && (id = null) != null) {
                        if (correlationID != null) {
                            String error = "User cannot set CamelCorrelationID when making a request/reply invocation using a static replyTo Queue.";
                        }
                        correlationID = id;
                    }
                    if (correlationID != null) {
                        reply.getIn().setHeader("org.apache.cxf.camel.correlationId", correlationID);
                    }
                    CamelConduit.this.getLogger().log(Level.FINE, "template sending request: ", reply.getIn());
                }
            });
        }

        private void handleResponse() throws IOException {
            Object response = null;
            MessageImpl inMessage = new MessageImpl();
            this.outMessage.getExchange().setInMessage((Message)inMessage);
            CamelConduit.this.getLogger().log(Level.FINE, "The Response Message is : [" + response + "]");
            byte[] bytes = null;
            if (response instanceof String) {
                String requestString = response;
                bytes = requestString.getBytes();
            } else {
                bytes = response;
            }
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
            CamelConduit.this.getLogger().log(Level.FINE, "incoming observer is " + CamelConduit.this.incomingObserver);
            CamelConduit.this.incomingObserver.onMessage((Message)inMessage);
        }
    }
}

