/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_MappingConfiguration;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Read;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_ReadFiles;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Sink;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Write;
import org.apache.beam.sdk.io.xml.JAXBCoder;
import org.apache.beam.sdk.io.xml.XmlSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.base.Preconditions;

public class XmlIO {
    public static <T> Read<T> read() {
        return new AutoValue_XmlIO_Read.Builder().setConfiguration(new AutoValue_XmlIO_MappingConfiguration.Builder().setCharset(StandardCharsets.UTF_8.name()).build()).setMinBundleSize(1L).setCompression(Compression.AUTO).build();
    }

    public static <T> ReadFiles<T> readFiles() {
        return new AutoValue_XmlIO_ReadFiles.Builder().setConfiguration(new AutoValue_XmlIO_MappingConfiguration.Builder().setCharset(StandardCharsets.UTF_8.name()).build()).build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_XmlIO_Write.Builder().setCharset(StandardCharsets.UTF_8.name()).build();
    }

    public static <T> Sink<T> sink(Class<T> recordClass) {
        return new AutoValue_XmlIO_Sink.Builder<T>().setRecordClass(recordClass).setCharset(StandardCharsets.UTF_8.name()).build();
    }

    @AutoValue
    public static abstract class Sink<T>
    implements FileIO.Sink<T> {
        private transient OutputStream outputStream;
        private transient Marshaller marshaller;

        abstract Class<T> getRecordClass();

        @Nullable
        abstract String getRootElement();

        abstract String getCharset();

        abstract Builder<T> toBuilder();

        public Sink<T> withRootElement(String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public Sink<T> withCharset(Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public void open(WritableByteChannel channel) throws IOException {
            Preconditions.checkArgument(this.getRootElement() != null, ".withRootElement() is required");
            try {
                this.marshaller = JAXBContext.newInstance((Class[])new Class[]{this.getRecordClass()}).createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.marshaller.setProperty("jaxb.encoding", (Object)this.getCharset());
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
            this.outputStream = Channels.newOutputStream(channel);
            this.outputStream.write(("<" + this.getRootElement() + ">\n").getBytes(Charset.forName(this.getCharset())));
        }

        public void write(T element) throws IOException {
            try {
                this.marshaller.marshal(element, this.outputStream);
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }

        public void flush() throws IOException {
            this.outputStream.write(("\n</" + this.getRootElement() + ">").getBytes(Charset.forName(this.getCharset())));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setRootElement(String var1);

            abstract Builder<T> setCharset(String var1);

            abstract Sink<T> build();
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract String getFilenamePrefix();

        @Nullable
        abstract Class<T> getRecordClass();

        @Nullable
        abstract String getRootElement();

        @Nullable
        abstract String getCharset();

        abstract Builder<T> toBuilder();

        public Write<T> to(String filenamePrefix) {
            return this.toBuilder().setFilenamePrefix(filenamePrefix).build();
        }

        public Write<T> withRecordClass(Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        public Write<T> withRootElement(String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public Write<T> withCharset(Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public PDone expand(PCollection<T> input) {
            Preconditions.checkArgument(this.getRecordClass() != null, "withRecordClass() is required");
            Preconditions.checkArgument(this.getRootElement() != null, "withRootElement() is required");
            Preconditions.checkArgument(this.getFilenamePrefix() != null, "to() is required");
            Preconditions.checkArgument(this.getCharset() != null, "withCharset() is required");
            try {
                JAXBContext.newInstance((Class[])new Class[]{this.getRecordClass()});
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error binding classes to a JAXB Context.", e);
            }
            ResourceId prefix = FileSystems.matchNewResource((String)this.getFilenamePrefix(), (boolean)false);
            input.apply((PTransform)FileIO.write().via(XmlIO.sink(this.getRecordClass()).withCharset(Charset.forName(this.getCharset())).withRootElement(this.getRootElement())).to(prefix.getCurrentDirectory().toString()).withPrefix(prefix.getFilename()).withSuffix(".xml").withIgnoreWindowing());
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFilenamePrefix(String var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setRootElement(String var1);

            abstract Builder<T> setCharset(String var1);

            abstract Write<T> build();
        }
    }

    private static class CreateSourceFn<T>
    implements SerializableFunction<String, XmlSource<T>> {
        private final MappingConfiguration<T> configuration;

        public CreateSourceFn(MappingConfiguration<T> configuration) {
            this.configuration = configuration;
        }

        public XmlSource<T> apply(String input) {
            return new XmlSource<T>((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input), this.configuration, 1L);
        }
    }

    @AutoValue
    public static abstract class ReadFiles<T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract MappingConfiguration<T> getConfiguration();

        abstract Builder<T> toBuilder();

        private ReadFiles<T> withConfiguration(MappingConfiguration<T> configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public ReadFiles<T> withRootElement(String rootElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRootElement(rootElement));
        }

        public ReadFiles<T> withRecordElement(String recordElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordElement(recordElement));
        }

        public ReadFiles<T> withRecordClass(Class<T> recordClass) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordClass(recordClass));
        }

        public ReadFiles<T> withCharset(Charset charset) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withCharset(charset));
        }

        public ReadFiles<T> withValidationEventHandler(ValidationEventHandler validationEventHandler) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withValidationEventHandler(validationEventHandler));
        }

        public PCollection<T> expand(PCollection<FileIO.ReadableFile> input) {
            return (PCollection)input.apply((PTransform)new ReadAllViaFileBasedSource(0x4000000L, new CreateSourceFn<T>(this.getConfiguration()), JAXBCoder.of(this.getConfiguration().getRecordClass())));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setConfiguration(MappingConfiguration<T> var1);

            abstract ReadFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract MappingConfiguration<T> getConfiguration();

        @Nullable
        abstract String getFileOrPatternSpec();

        abstract Compression getCompression();

        abstract long getMinBundleSize();

        abstract Builder<T> toBuilder();

        public Read<T> from(String fileOrPatternSpec) {
            return this.toBuilder().setFileOrPatternSpec(fileOrPatternSpec).build();
        }

        private Read<T> withConfiguration(MappingConfiguration<T> configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public Read<T> withRootElement(String rootElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRootElement(rootElement));
        }

        public Read<T> withRecordElement(String recordElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordElement(recordElement));
        }

        public Read<T> withRecordClass(Class<T> recordClass) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordClass(recordClass));
        }

        public Read<T> withMinBundleSize(long minBundleSize) {
            return this.toBuilder().setMinBundleSize(minBundleSize).build();
        }

        @Deprecated
        public Read<T> withCompressionType(CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public Read<T> withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public Read<T> withCharset(Charset charset) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withCharset(charset));
        }

        public Read<T> withValidationEventHandler(ValidationEventHandler validationEventHandler) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withValidationEventHandler(validationEventHandler));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.addIfNotDefault(DisplayData.item((String)"minBundleSize", (Long)this.getMinBundleSize()).withLabel("Minimum Bundle Size"), (Object)1L).add(DisplayData.item((String)"filePattern", (String)this.getFileOrPatternSpec()).withLabel("File Pattern")).include("configuration", this.getConfiguration());
        }

        @VisibleForTesting
        BoundedSource<T> createSource() {
            return CompressedSource.from(new XmlSource<T>((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)this.getFileOrPatternSpec()), this.getConfiguration(), 1L)).withCompression(this.getCompression());
        }

        public PCollection<T> expand(PBegin input) {
            ((MappingConfiguration)this.getConfiguration()).validate();
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createSource()));
        }

        @Deprecated
        public static enum CompressionType {
            AUTO(Compression.AUTO),
            UNCOMPRESSED(Compression.UNCOMPRESSED),
            GZIP(Compression.GZIP),
            BZIP2(Compression.BZIP2),
            ZIP(Compression.ZIP),
            DEFLATE(Compression.DEFLATE);

            private Compression canonical;

            private CompressionType(Compression canonical) {
                this.canonical = canonical;
            }

            public boolean matches(String filename) {
                return this.canonical.matches(filename);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setConfiguration(MappingConfiguration<T> var1);

            abstract Builder<T> setFileOrPatternSpec(String var1);

            abstract Builder<T> setCompression(Compression var1);

            abstract Builder<T> setMinBundleSize(long var1);

            abstract Read<T> build();
        }
    }

    @AutoValue
    static abstract class MappingConfiguration<T>
    implements HasDisplayData,
    Serializable {
        MappingConfiguration() {
        }

        @Nullable
        abstract String getRootElement();

        @Nullable
        abstract String getRecordElement();

        @Nullable
        abstract Class<T> getRecordClass();

        @Nullable
        abstract String getCharset();

        @Nullable
        abstract ValidationEventHandler getValidationEventHandler();

        abstract Builder<T> toBuilder();

        private MappingConfiguration<T> withRootElement(String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        private MappingConfiguration<T> withRecordElement(String recordElement) {
            return this.toBuilder().setRecordElement(recordElement).build();
        }

        private MappingConfiguration<T> withRecordClass(Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        private MappingConfiguration<T> withCharset(Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        private MappingConfiguration<T> withValidationEventHandler(ValidationEventHandler validationEventHandler) {
            return this.toBuilder().setValidationEventHandler(validationEventHandler).build();
        }

        private void validate() {
            Preconditions.checkArgument(this.getRootElement() != null, "withRootElement() is required");
            Preconditions.checkArgument(this.getRecordElement() != null, "withRecordElement() is required");
            Preconditions.checkArgument(this.getRecordClass() != null, "withRecordClass() is required");
            Preconditions.checkArgument(this.getCharset() != null, "withCharset() is required");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordElement", (String)this.getRecordElement()).withLabel("XML Record Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setRootElement(String var1);

            abstract Builder<T> setRecordElement(String var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setCharset(String var1);

            abstract Builder<T> setValidationEventHandler(ValidationEventHandler var1);

            abstract MappingConfiguration<T> build();
        }
    }
}

