/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.xml.XmlIO;

final class AutoValue_XmlIO_Read<T>
extends XmlIO.Read<T> {
    private final XmlIO.MappingConfiguration<T> configuration;
    private final String fileOrPatternSpec;
    private final Compression compression;
    private final long minBundleSize;

    private AutoValue_XmlIO_Read(XmlIO.MappingConfiguration<T> configuration, @Nullable String fileOrPatternSpec, Compression compression, long minBundleSize) {
        this.configuration = configuration;
        this.fileOrPatternSpec = fileOrPatternSpec;
        this.compression = compression;
        this.minBundleSize = minBundleSize;
    }

    @Override
    XmlIO.MappingConfiguration<T> getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    String getFileOrPatternSpec() {
        return this.fileOrPatternSpec;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    long getMinBundleSize() {
        return this.minBundleSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof XmlIO.Read) {
            XmlIO.Read that = (XmlIO.Read)((Object)o);
            return this.configuration.equals(that.getConfiguration()) && (this.fileOrPatternSpec == null ? that.getFileOrPatternSpec() == null : this.fileOrPatternSpec.equals(that.getFileOrPatternSpec())) && this.compression.equals((Object)that.getCompression()) && this.minBundleSize == that.getMinBundleSize();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.configuration.hashCode();
        h *= 1000003;
        h ^= this.fileOrPatternSpec == null ? 0 : this.fileOrPatternSpec.hashCode();
        h *= 1000003;
        h ^= this.compression.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.minBundleSize >>> 32 ^ this.minBundleSize));
        return h;
    }

    @Override
    XmlIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends XmlIO.Read.Builder<T> {
        private XmlIO.MappingConfiguration<T> configuration;
        private String fileOrPatternSpec;
        private Compression compression;
        private Long minBundleSize;

        Builder() {
        }

        private Builder(XmlIO.Read<T> source) {
            this.configuration = source.getConfiguration();
            this.fileOrPatternSpec = source.getFileOrPatternSpec();
            this.compression = source.getCompression();
            this.minBundleSize = source.getMinBundleSize();
        }

        @Override
        XmlIO.Read.Builder<T> setConfiguration(XmlIO.MappingConfiguration<T> configuration) {
            if (configuration == null) {
                throw new NullPointerException("Null configuration");
            }
            this.configuration = configuration;
            return this;
        }

        @Override
        XmlIO.Read.Builder<T> setFileOrPatternSpec(@Nullable String fileOrPatternSpec) {
            this.fileOrPatternSpec = fileOrPatternSpec;
            return this;
        }

        @Override
        XmlIO.Read.Builder<T> setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        XmlIO.Read.Builder<T> setMinBundleSize(long minBundleSize) {
            this.minBundleSize = minBundleSize;
            return this;
        }

        @Override
        XmlIO.Read<T> build() {
            String missing = "";
            if (this.configuration == null) {
                missing = missing + " configuration";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (this.minBundleSize == null) {
                missing = missing + " minBundleSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_XmlIO_Read(this.configuration, this.fileOrPatternSpec, this.compression, this.minBundleSize);
        }
    }
}

