/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.util.EmptyOnDeserializationThreadLocal;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

public class JAXBCoder<T>
extends CustomCoder<T> {
    private final Class<T> jaxbClass;
    private volatile transient JAXBContext jaxbContext;
    private final EmptyOnDeserializationThreadLocal<Marshaller> jaxbMarshaller;
    private final EmptyOnDeserializationThreadLocal<Unmarshaller> jaxbUnmarshaller;

    public Class<T> getJAXBClass() {
        return this.jaxbClass;
    }

    private JAXBCoder(Class<T> jaxbClass) {
        this.jaxbClass = jaxbClass;
        this.jaxbMarshaller = new EmptyOnDeserializationThreadLocal<Marshaller>(){

            protected Marshaller initialValue() {
                try {
                    JAXBContext jaxbContext = JAXBCoder.this.getContext();
                    return jaxbContext.createMarshaller();
                }
                catch (JAXBException e) {
                    throw new RuntimeException("Error when creating marshaller from JAXB Context.", e);
                }
            }
        };
        this.jaxbUnmarshaller = new EmptyOnDeserializationThreadLocal<Unmarshaller>(){

            protected Unmarshaller initialValue() {
                try {
                    JAXBContext jaxbContext = JAXBCoder.this.getContext();
                    return jaxbContext.createUnmarshaller();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error when creating unmarshaller from JAXB Context.", e);
                }
            }
        };
    }

    public static <T> JAXBCoder<T> of(Class<T> jaxbClass) {
        return new JAXBCoder<T>(jaxbClass);
    }

    public void encode(T value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            try {
                ((Marshaller)this.jaxbMarshaller.get()).marshal(value, (OutputStream)new CloseIgnoringOutputStream(outStream));
            }
            catch (JAXBException e) {
                throw new CoderException((Throwable)e);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((Marshaller)this.jaxbMarshaller.get()).marshal(value, (OutputStream)baos);
        }
        catch (JAXBException e) {
            throw new CoderException((Throwable)e);
        }
        VarInt.encode((int)baos.size(), (OutputStream)outStream);
        baos.writeTo(outStream);
    }

    public T decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        try {
            if (!context.isWholeStream) {
                long limit = VarInt.decodeLong((InputStream)inStream);
                inStream = ByteStreams.limit((InputStream)inStream, (long)limit);
            }
            Object obj = ((Unmarshaller)this.jaxbUnmarshaller.get()).unmarshal((InputStream)new CloseIgnoringInputStream(inStream));
            return (T)obj;
        }
        catch (JAXBException e) {
            throw new CoderException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getContext() throws JAXBException {
        if (this.jaxbContext == null) {
            JAXBCoder jAXBCoder = this;
            synchronized (jAXBCoder) {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.jaxbClass});
                }
            }
        }
        return this.jaxbContext;
    }

    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(this.jaxbClass);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JAXBCoder)) {
            return false;
        }
        JAXBCoder that = (JAXBCoder)((Object)other);
        return Objects.equals(this.jaxbClass, that.jaxbClass);
    }

    public int hashCode() {
        return this.jaxbClass.hashCode();
    }

    private static class CloseIgnoringOutputStream
    extends FilterOutputStream {
        CloseIgnoringOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }
    }

    private static class CloseIgnoringInputStream
    extends FilterInputStream {
        CloseIgnoringInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

