/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface TikaOptions
extends PipelineOptions {
    @Description(value="Input path")
    @Validation.Required
    public String getInput();

    public void setInput(String var1);

    @Description(value="Tika Config path")
    public String getTikaConfigPath();

    public void setTikaConfigPath(String var1);

    @Description(value="Tika Parser Content Type hint")
    public String getContentTypeHint();

    public void setContentTypeHint(String var1);

    @Description(value="Metadata report status")
    @Default.Boolean(value=false)
    public Boolean getReadOutputMetadata();

    public void setReadOutputMetadata(Boolean var1);

    @Description(value="Optional use of the synchronous reader")
    @Default.Boolean(value=false)
    public Boolean getParseSynchronously();

    public void setParseSynchronously(Boolean var1);

    @Description(value="Tika Parser queue poll time in milliseconds")
    @Default.Long(value=50L)
    public Long getQueuePollTime();

    public void setQueuePollTime(Long var1);

    @Description(value="Tika Parser queue maximum poll time in milliseconds")
    @Default.Long(value=3000L)
    public Long getQueueMaxPollTime();

    public void setQueueMaxPollTime(Long var1);

    @Description(value="Minumin text fragment length for Tika Parser to report")
    @Default.Integer(value=0)
    public Integer getMinimumTextLength();

    public void setMinimumTextLength(Integer var1);

    @Description(value="Pipeline name")
    @Default.String(value="TikaRead")
    public String getPipelineName();

    public void setPipelineName(String var1);

    @Description(value="Output path")
    @Default.String(value="/tmp/tika/out")
    public String getOutput();

    public void setOutput(String var1);
}

