/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KeyPairUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
    private static final @UnknownKeyFor @NonNull @Initialized String UNENCRYPTED_PRIVATE_KEY = "PRIVATE KEY";

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public static @UnknownKeyFor @NonNull @Initialized PrivateKey preparePrivateKey(@UnknownKeyFor @NonNull @Initialized String privateKey, @UnknownKeyFor @NonNull @Initialized String privateKeyPassphrase) {
        try {
            byte[] decoded;
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            KeyEncryptionState encryptionState = KeyPairUtils.guessKeyEncryptionState(privateKey);
            if (encryptionState == KeyEncryptionState.ENCRYPT && Strings.isNullOrEmpty((String)privateKeyPassphrase)) {
                throw new RuntimeException("The private key is encrypted but no private key key passphrase has been provided.");
            }
            if (encryptionState == KeyEncryptionState.UNENCRYPTED && !Strings.isNullOrEmpty((String)privateKeyPassphrase)) {
                throw new RuntimeException("The private key is unencrypted but private key key passphrase has been provided.");
            }
            if (encryptionState == KeyEncryptionState.UNKNOWN) {
                decoded = Base64.decode((String)privateKey);
            } else {
                PemReader pr = new PemReader((Reader)new StringReader(privateKey));
                PemObject pemObject = pr.readPemObject();
                decoded = pemObject.getContent();
                pr.close();
            }
            if (Strings.isNullOrEmpty((String)privateKeyPassphrase)) {
                PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(decoded);
                return keyFactory.generatePrivate(encodedKeySpec);
            }
            EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(decoded);
            PBEKeySpec keySpec = new PBEKeySpec(privateKeyPassphrase.toCharArray());
            SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(pkInfo.getAlgName());
            PKCS8EncodedKeySpec encodedKeySpec = pkInfo.getKeySpec(pbeKeyFactory.generateSecret(keySpec));
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Private key encryption algorithm not supported. This may mean that the private key was generated by OpenSSL 1.1.1g or newer which uses an encryption algorithm by default which has compatibility issues in some JVM environments. For details, see: https://community.snowflake.com/s/article/Private-key-provided-is-invalid-or-not-supported-rsa-key-p8--data-isn-t-an-object-ID " + e.getMessage());
        }
        catch (IOException | IllegalArgumentException | NullPointerException | InvalidKeyException | InvalidKeySpecException | DecoderException e) {
            throw new RuntimeException("Can't create private key: " + e.getMessage(), e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized KeyEncryptionState guessKeyEncryptionState(@UnknownKeyFor @NonNull @Initialized String privateKey) {
        PemReader pr = new PemReader((Reader)new StringReader(privateKey));
        try {
            PemObject pemObject = pr.readPemObject();
            if (pemObject == null) {
                return KeyEncryptionState.UNKNOWN;
            }
            if (ENCRYPTED_PRIVATE_KEY.equals(pemObject.getType())) {
                return KeyEncryptionState.ENCRYPT;
            }
            if (UNENCRYPTED_PRIVATE_KEY.equals(pemObject.getType())) {
                return KeyEncryptionState.UNENCRYPTED;
            }
            throw new RuntimeException("Invalid type of PEM file: " + pemObject.getType() + ". Supported types: " + ENCRYPTED_PRIVATE_KEY + ", " + UNENCRYPTED_PRIVATE_KEY);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read parse private key");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String readPrivateKeyFile(@UnknownKeyFor @NonNull @Initialized String privateKeyPath) {
        try {
            byte[] keyBytes = Files.readAllBytes(Paths.get(privateKeyPath, new String[0]));
            return new String(keyBytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read private key from provided path");
        }
    }

    private static enum KeyEncryptionState {
        ENCRYPT,
        UNENCRYPTED,
        UNKNOWN;

    }
}

