/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data;

import java.io.Serializable;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonProperty;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeColumn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SnowflakeTableSchema
implements Serializable {
    @JsonProperty(value="schema")
    private @UnknownKeyFor @NonNull @Initialized SnowflakeColumn @UnknownKeyFor @NonNull @Initialized [] columns;

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeTableSchema of(SnowflakeColumn ... columns) {
        return new SnowflakeTableSchema(columns);
    }

    public SnowflakeTableSchema() {
    }

    public SnowflakeTableSchema(SnowflakeColumn ... columns) {
        this.columns = columns;
    }

    public @UnknownKeyFor @NonNull @Initialized String sql() {
        ArrayList<String> columnsSqls = new ArrayList<String>();
        for (SnowflakeColumn column : this.columns) {
            columnsSqls.add(column.sql());
        }
        return Joiner.on((String)", ").join(columnsSqls);
    }

    public @UnknownKeyFor @NonNull @Initialized SnowflakeColumn @UnknownKeyFor @NonNull @Initialized [] getColumns() {
        return this.columns;
    }

    public void setColumns(@UnknownKeyFor @NonNull @Initialized SnowflakeColumn @UnknownKeyFor @NonNull @Initialized [] columns) {
        this.columns = columns;
    }
}

