/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data.text;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;

public class SnowflakeVarchar
implements SnowflakeDataType,
Serializable {
    public static final Long MAX_LENGTH = 0x1000000L;
    private Long length;

    public static SnowflakeVarchar of() {
        return new SnowflakeVarchar();
    }

    public static SnowflakeVarchar of(long length) {
        return new SnowflakeVarchar(length);
    }

    public SnowflakeVarchar() {
    }

    public SnowflakeVarchar(long length) {
        if (length > MAX_LENGTH) {
            throw new IllegalArgumentException(String.format("Provided length %s is bigger than max length %s ", length, MAX_LENGTH));
        }
        this.length = length;
    }

    @Override
    public String sql() {
        if (this.length != null) {
            return String.format("VARCHAR(%d)", this.length);
        }
        return "VARCHAR";
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }
}

