/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.crosslanguage;

import java.io.IOException;
import java.util.List;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.crosslanguage.CrossLanguageConfiguration;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

@Experimental(value=Experimental.Kind.PORTABILITY)
public class WriteBuilder
implements ExternalTransformBuilder<Configuration, PCollection<byte[]>, PDone> {
    public PTransform<PCollection<byte[]>, PDone> buildExternal(Configuration c) {
        return SnowflakeIO.write().withDataSourceConfiguration(c.getDataSourceConfiguration()).withStorageIntegrationName(c.getStorageIntegrationName()).withStagingBucketName(c.getStagingBucketName()).withTableSchema(c.getTableSchema()).withCreateDisposition(c.getCreateDisposition()).withWriteDisposition(c.getWriteDisposition()).withUserDataMapper(WriteBuilder.getStringCsvMapper()).withQueryTransformation(c.getQuery()).to(c.getTable());
    }

    private static SnowflakeIO.UserDataMapper<List<byte[]>> getStringCsvMapper() {
        return recordLine -> recordLine.stream().map(String::new).toArray();
    }

    public static class Configuration
    extends CrossLanguageConfiguration {
        private SnowflakeTableSchema tableSchema;
        private CreateDisposition createDisposition;
        private WriteDisposition writeDisposition;

        public void setTableSchema(String tableSchema) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.tableSchema = (SnowflakeTableSchema)mapper.readValue(tableSchema, SnowflakeTableSchema.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Format of provided table schema is invalid");
            }
        }

        public void setCreateDisposition(String createDisposition) {
            this.createDisposition = CreateDisposition.valueOf(createDisposition);
        }

        public void setWriteDisposition(String writeDisposition) {
            this.writeDisposition = WriteDisposition.valueOf(writeDisposition);
        }

        public SnowflakeTableSchema getTableSchema() {
            return this.tableSchema;
        }

        public CreateDisposition getCreateDisposition() {
            return this.createDisposition;
        }

        public WriteDisposition getWriteDisposition() {
            return this.writeDisposition;
        }
    }
}

