/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.services;

import java.util.List;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.ServiceConfig;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class SnowflakeBatchServiceConfig
extends ServiceConfig {
    private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
    private final String database;
    private final String schema;
    private final String table;
    private final String query;
    private final String storageIntegrationName;
    private List<String> filesList;
    private WriteDisposition writeDisposition;
    private CreateDisposition createDisposition;
    private SnowflakeTableSchema tableSchema;
    private final String stagingBucketDir;
    private final String quotationMark;

    public SnowflakeBatchServiceConfig(SerializableFunction<Void, DataSource> dataSourceProviderFn, String database, String schema, String table, String query, String storageIntegrationName, String stagingBucketDir, String quotationMark) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.query = query;
        this.storageIntegrationName = storageIntegrationName;
        this.stagingBucketDir = stagingBucketDir;
        this.quotationMark = quotationMark;
    }

    public SnowflakeBatchServiceConfig(SerializableFunction<Void, DataSource> dataSourceProviderFn, List<String> filesList, String database, String schema, String table, String query, SnowflakeTableSchema tableSchema, CreateDisposition createDisposition, WriteDisposition writeDisposition, String storageIntegrationName, String stagingBucketDir, String quotationMark) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.filesList = filesList;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.query = query;
        this.writeDisposition = writeDisposition;
        this.createDisposition = createDisposition;
        this.tableSchema = tableSchema;
        this.storageIntegrationName = storageIntegrationName;
        this.stagingBucketDir = stagingBucketDir;
        this.quotationMark = quotationMark;
    }

    public SerializableFunction<Void, DataSource> getDataSourceProviderFn() {
        return this.dataSourceProviderFn;
    }

    public String getTable() {
        return this.table;
    }

    public String getQuery() {
        return this.query;
    }

    public String getStorageIntegrationName() {
        return this.storageIntegrationName;
    }

    public String getStagingBucketDir() {
        return this.stagingBucketDir;
    }

    public List<String> getFilesList() {
        return this.filesList;
    }

    public WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public String getQuotationMark() {
        return this.quotationMark;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public SnowflakeTableSchema getTableSchema() {
        return this.tableSchema;
    }
}

