/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data.text;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;

public class SnowflakeBinary
implements SnowflakeDataType,
Serializable {
    public static final Long MAX_SIZE = 0x800000L;
    private Long size;

    public SnowflakeBinary() {
    }

    public static SnowflakeBinary of() {
        return new SnowflakeBinary();
    }

    public static SnowflakeBinary of(long size) {
        return new SnowflakeBinary(size);
    }

    public SnowflakeBinary(long size) {
        if (size > MAX_SIZE) {
            throw new IllegalArgumentException(String.format("Provided size %s is bigger than max size %s ", size, MAX_SIZE));
        }
        this.size = size;
    }

    @Override
    public String sql() {
        if (this.size != null) {
            return String.format("BINARY(%d)", this.size);
        }
        return "BINARY";
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }
}

