/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.crosslanguage;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentialsFactory;
import org.apache.beam.sdk.io.snowflake.crosslanguage.Configuration;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Experimental
public final class SnowflakeReadRegistrar
implements ExternalTransformRegistrar {
    public static final String URN = "beam:external:java:snowflake:read:v1";

    public Map<String, Class<? extends ExternalTransformBuilder<?, ?, ?>>> knownBuilders() {
        return ImmutableMap.of((Object)URN, ReadBuilder.class);
    }

    private static class CsvMapper
    implements Serializable {
        private CsvMapper() {
        }

        public static SnowflakeIO.CsvMapper getCsvMapper() {
            return parts -> {
                String partsCSV = String.join((CharSequence)",", parts);
                return partsCSV.getBytes(Charset.defaultCharset());
            };
        }
    }

    public static class ReadBuilder
    implements ExternalTransformBuilder<ReadConfiguration, PBegin, PCollection<byte[]>> {
        public PTransform<PBegin, PCollection<byte[]>> buildExternal(ReadConfiguration c) {
            SnowflakeCredentials credentials = SnowflakeCredentialsFactory.of(c);
            SerializableFunction<Void, DataSource> dataSourceSerializableFunction = SnowflakeIO.DataSourceProviderFromDataSourceConfiguration.of(SnowflakeIO.DataSourceConfiguration.create(credentials).withServerName(c.getServerName()).withDatabase(c.getDatabase()).withSchema(c.getSchema()));
            return SnowflakeIO.read().withStorageIntegrationName(c.getStorageIntegrationName()).withStagingBucketName(c.getStagingBucketName()).withDataSourceProviderFn(dataSourceSerializableFunction).withCsvMapper(CsvMapper.getCsvMapper()).withCoder(ByteArrayCoder.of()).fromTable(c.getTable()).fromQuery(c.getQuery());
        }
    }

    public static class ReadConfiguration
    extends Configuration {
    }
}

