/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import com.google.auto.value.AutoValue;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryResponse;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Read;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Write;
import org.apache.beam.sdk.io.snowflake.credentials.KeyPairSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.OAuthTokenSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.UsernamePasswordSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.StreamingLogLevel;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeBatchServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeBatchServiceImpl;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeService;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceImpl;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SnowflakeIO {
    private static final Logger LOG = LoggerFactory.getLogger(SnowflakeIO.class);
    private static final String CSV_QUOTE_CHAR = "'";
    static final int DEFAULT_FLUSH_ROW_LIMIT = 10000;
    static final int DEFAULT_STREAMING_SHARDS_NUMBER = 1;
    static final int DEFAULT_BATCH_SHARDS_NUMBER = 0;
    static final Duration DEFAULT_FLUSH_TIME_LIMIT = Duration.millis((long)30000L);
    static final Duration DEFAULT_STREAMING_LOGS_MAX_SLEEP = Duration.standardMinutes((long)2L);
    static final Duration DEFAULT_SLEEP_STREAMING_LOGS = Duration.standardSeconds((long)5000L);

    public static <T> Read<T> read(SnowflakeService snowflakeService) {
        return new AutoValue_SnowflakeIO_Read.Builder().setSnowflakeService(snowflakeService).setQuotationMark(CSV_QUOTE_CHAR).build();
    }

    public static <T> Read<T> read() {
        return SnowflakeIO.read(new SnowflakeBatchServiceImpl());
    }

    public static <T> Write<T> write() {
        return new AutoValue_SnowflakeIO_Write.Builder().setFileNameTemplate("output").setCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(WriteDisposition.APPEND).setFlushTimeLimit(DEFAULT_FLUSH_TIME_LIMIT).setShardsNumber(0).setFlushRowLimit(10000).setQuotationMark(CSV_QUOTE_CHAR).build();
    }

    private static String getValueOrNull(ValueProvider<String> valueProvider) {
        return valueProvider != null ? (String)valueProvider.get() : null;
    }

    public static class DataSourceProviderFromDataSourceConfiguration
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final ConcurrentHashMap<DataSourceConfiguration, DataSource> instances = new ConcurrentHashMap();
        private final DataSourceConfiguration config;

        private DataSourceProviderFromDataSourceConfiguration(DataSourceConfiguration config) {
            if (config.getValidate().booleanValue()) {
                try {
                    Connection connection = config.buildDatasource().getConnection();
                    connection.close();
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException("Invalid DataSourceConfiguration. Underlying cause: " + e);
                }
            }
            this.config = config;
        }

        public static SerializableFunction<Void, DataSource> of(DataSourceConfiguration config) {
            return new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public DataSource apply(Void input) {
            return instances.computeIfAbsent(this.config, config -> config.buildDatasource());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }

        public DataSourceConfiguration getConfig() {
            return this.config;
        }
    }

    @AutoValue
    public static abstract class DataSourceConfiguration
    implements Serializable {
        public abstract @Nullable String getUrl();

        public abstract @Nullable String getUsername();

        public abstract @Nullable String getPassword();

        public abstract @Nullable PrivateKey getPrivateKey();

        public abstract @Nullable String getOauthToken();

        public abstract @Nullable String getDatabase();

        public abstract @Nullable String getWarehouse();

        public abstract @Nullable String getSchema();

        public abstract @Nullable String getServerName();

        public abstract @Nullable Integer getPortNumber();

        public abstract @Nullable String getRole();

        public abstract @Nullable Integer getLoginTimeout();

        public abstract @Nullable Boolean getSsl();

        public abstract @Nullable Boolean getValidate();

        public abstract @Nullable DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(SnowflakeCredentials credentials) {
            if (credentials instanceof UsernamePasswordSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setUsername(((UsernamePasswordSnowflakeCredentials)credentials).getUsername()).setPassword(((UsernamePasswordSnowflakeCredentials)credentials).getPassword()).build();
            }
            if (credentials instanceof OAuthTokenSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setOauthToken(((OAuthTokenSnowflakeCredentials)credentials).getToken()).build();
            }
            if (credentials instanceof KeyPairSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setUsername(((KeyPairSnowflakeCredentials)credentials).getUsername()).setPrivateKey(((KeyPairSnowflakeCredentials)credentials).getPrivateKey()).build();
            }
            throw new IllegalArgumentException("Can't create DataSourceConfiguration from given credentials");
        }

        public DataSourceConfiguration withUrl(String url) {
            Preconditions.checkArgument((boolean)url.startsWith("jdbc:snowflake://"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            Preconditions.checkArgument((boolean)url.endsWith("snowflakecomputing.com"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            return this.builder().setUrl(url).build();
        }

        public DataSourceConfiguration withDatabase(String database) {
            return this.builder().setDatabase(database).build();
        }

        public DataSourceConfiguration withWarehouse(String warehouse) {
            return this.builder().setWarehouse(warehouse).build();
        }

        public DataSourceConfiguration withSchema(String schema) {
            return this.builder().setSchema(schema).build();
        }

        public DataSourceConfiguration withServerName(String serverName) {
            Preconditions.checkArgument((boolean)serverName.endsWith("snowflakecomputing.com"), (Object)"serverName must be in format <account_name>.snowflakecomputing.com");
            return this.builder().setServerName(serverName).build();
        }

        public DataSourceConfiguration withPortNumber(Integer portNumber) {
            return this.builder().setPortNumber(portNumber).build();
        }

        public DataSourceConfiguration withRole(String role) {
            return this.builder().setRole(role).build();
        }

        public DataSourceConfiguration withLoginTimeout(Integer loginTimeout) {
            return this.builder().setLoginTimeout(loginTimeout).build();
        }

        public DataSourceConfiguration withoutValidation() {
            return this.builder().setValidate(false).build();
        }

        void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            }
        }

        public DataSource buildDatasource() {
            if (this.getDataSource() == null) {
                SnowflakeBasicDataSource basicDataSource = new SnowflakeBasicDataSource();
                basicDataSource.setUrl(this.buildUrl());
                if (this.getUsername() != null) {
                    basicDataSource.setUser(this.getUsername());
                }
                if (this.getPassword() != null) {
                    basicDataSource.setPassword(this.getPassword());
                }
                if (this.getPrivateKey() != null) {
                    basicDataSource.setPrivateKey(this.getPrivateKey());
                }
                if (this.getDatabase() != null) {
                    basicDataSource.setDatabaseName(this.getDatabase());
                }
                if (this.getWarehouse() != null) {
                    basicDataSource.setWarehouse(this.getWarehouse());
                }
                if (this.getSchema() != null) {
                    basicDataSource.setSchema(this.getSchema());
                }
                if (this.getRole() != null) {
                    basicDataSource.setRole(this.getRole());
                }
                if (this.getLoginTimeout() != null) {
                    try {
                        basicDataSource.setLoginTimeout(this.getLoginTimeout().intValue());
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to setLoginTimeout");
                    }
                }
                if (this.getOauthToken() != null) {
                    basicDataSource.setOauthToken(this.getOauthToken());
                }
                return basicDataSource;
            }
            return this.getDataSource();
        }

        private String buildUrl() {
            StringBuilder url = new StringBuilder();
            if (this.getUrl() != null) {
                url.append(this.getUrl());
            } else {
                url.append("jdbc:snowflake://");
                url.append(this.getServerName());
            }
            if (this.getPortNumber() != null) {
                url.append(":").append(this.getPortNumber());
            }
            url.append("?application=beam");
            return url.toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUrl(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setPrivateKey(PrivateKey var1);

            abstract Builder setOauthToken(String var1);

            abstract Builder setDatabase(String var1);

            abstract Builder setWarehouse(String var1);

            abstract Builder setSchema(String var1);

            abstract Builder setServerName(String var1);

            abstract Builder setPortNumber(Integer var1);

            abstract Builder setRole(String var1);

            abstract Builder setLoginTimeout(Integer var1);

            abstract Builder setSsl(Boolean var1);

            abstract Builder setValidate(Boolean var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    private static class StreamToTableFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final String stagingBucketDir;
        private final ValueProvider<String> snowPipe;
        private final StreamingLogLevel debugMode;
        private final SnowflakeService snowflakeService;
        private transient SimpleIngestManager ingestManager;
        private transient DataSource dataSource;
        ArrayList<String> trackedFilesNames;

        StreamToTableFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, ValueProvider<String> snowPipe, String stagingBucketDir, StreamingLogLevel debugMode, SnowflakeService snowflakeService) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.stagingBucketDir = stagingBucketDir;
            this.snowPipe = snowPipe;
            this.debugMode = debugMode;
            this.snowflakeService = snowflakeService;
            this.trackedFilesNames = new ArrayList();
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.dataSource = (DataSource)this.dataSourceProviderFn.apply(null);
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            Preconditions.checkArgument((config.getPrivateKey() != null ? 1 : 0) != 0, (Object)"KeyPair is required for authentication");
            String hostName = config.getServerName();
            List path = Splitter.on((char)'.').splitToList((CharSequence)hostName);
            String account = (String)path.get(0);
            String username = config.getUsername();
            PrivateKey privateKey = config.getPrivateKey();
            String schema = config.getSchema();
            String database = config.getDatabase();
            String snowPipeName = String.format("%s.%s.%s", database, schema, this.snowPipe.get());
            this.ingestManager = new SimpleIngestManager(account, username, snowPipeName, privateKey, "https", hostName, 443);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            List filesList = (List)context.element();
            if (this.debugMode != null) {
                this.trackedFilesNames.addAll(filesList);
            }
            SnowflakeStreamingServiceConfig config = new SnowflakeStreamingServiceConfig(filesList, this.stagingBucketDir, this.ingestManager);
            this.snowflakeService.write(config);
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            if (this.debugMode != null) {
                String beginMark = null;
                Duration currentSleep = Duration.ZERO;
                while (currentSleep.isShorterThan((ReadableDuration)DEFAULT_STREAMING_LOGS_MAX_SLEEP) && this.trackedFilesNames.size() > 0) {
                    Thread.sleep(DEFAULT_SLEEP_STREAMING_LOGS.getMillis());
                    currentSleep = currentSleep.plus((ReadableDuration)DEFAULT_SLEEP_STREAMING_LOGS);
                    HistoryResponse response = this.ingestManager.getHistory(null, null, beginMark);
                    if (response != null && response.getNextBeginMark() != null) {
                        beginMark = response.getNextBeginMark();
                    }
                    if (response == null || response.files == null) continue;
                    response.files.forEach(entry -> {
                        String responseFileName;
                        if (entry.getPath() != null && entry.isComplete().booleanValue() && this.trackedFilesNames.contains(responseFileName = String.format("'%s%s'", entry.getStageLocation(), entry.getPath()).toLowerCase().replace("gcs://", "gs://"))) {
                            this.trackedFilesNames.remove(responseFileName);
                            if (entry.getErrorsSeen() > 0L) {
                                LOG.error(String.format("Snowflake SnowPipe ERROR: %s", entry.toString()));
                            } else if (entry.getErrorsSeen() == 0L && this.debugMode.equals((Object)StreamingLogLevel.INFO)) {
                                LOG.info(String.format("Snowflake SnowPipe INFO: %s", entry.toString()));
                            }
                        }
                    });
                }
                this.trackedFilesNames.forEach(file -> LOG.info(String.format("File %s was not found in ingest history", file)));
            }
        }
    }

    private static class CopyToTableFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final String database;
        private final String schema;
        private final String table;
        private final String query;
        private final SnowflakeTableSchema tableSchema;
        private final String stagingBucketDir;
        private final String storageIntegrationName;
        private final String quotationMark;
        private final WriteDisposition writeDisposition;
        private final CreateDisposition createDisposition;
        private final SnowflakeService snowflakeService;

        CopyToTableFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, String table, String query, String stagingBucketDir, String storageIntegrationName, CreateDisposition createDisposition, WriteDisposition writeDisposition, SnowflakeTableSchema tableSchema, SnowflakeService snowflakeService, String quotationMark) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.query = query;
            this.table = table;
            this.stagingBucketDir = stagingBucketDir;
            this.storageIntegrationName = storageIntegrationName;
            this.writeDisposition = writeDisposition;
            this.createDisposition = createDisposition;
            this.tableSchema = tableSchema;
            this.snowflakeService = snowflakeService;
            this.quotationMark = quotationMark;
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            this.database = config.getDatabase();
            this.schema = config.getSchema();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, (List)context.element(), this.database, this.schema, this.table, this.query, this.tableSchema, this.createDisposition, this.writeDisposition, this.storageIntegrationName, this.stagingBucketDir, this.quotationMark);
            this.snowflakeService.write(config);
        }
    }

    private static class MapObjectsArrayToCsvFn
    extends DoFn<Object[], String> {
        private String quotationMark;

        public MapObjectsArrayToCsvFn(String quotationMark) {
            this.quotationMark = quotationMark;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            ArrayList<Object> csvItems = new ArrayList<Object>();
            for (Object o : (Object[])context.element()) {
                if (o instanceof String) {
                    String field = (String)o;
                    field = field.replace(SnowflakeIO.CSV_QUOTE_CHAR, "''");
                    field = this.quoteField(field);
                    csvItems.add(field);
                    continue;
                }
                csvItems.add(o);
            }
            context.output((Object)Joiner.on((String)",").useForNull("").join(csvItems));
        }

        private String quoteField(String field) {
            return this.quoteField(field, this.quotationMark);
        }

        private String quoteField(String field, String quotation) {
            return String.format("%s%s%s", quotation, field, quotation);
        }
    }

    public static class Concatenate
    extends Combine.CombineFn<String, List<String>, List<String>> {
        public List<String> createAccumulator() {
            return new ArrayList<String>();
        }

        public List<String> addInput(List<String> mutableAccumulator, String input) {
            mutableAccumulator.add(String.format("'%s'", input));
            return mutableAccumulator;
        }

        public List<String> mergeAccumulators(Iterable<List<String>> accumulators) {
            Object result = this.createAccumulator();
            for (List<String> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        public List<String> extractOutput(List<String> accumulator) {
            return accumulator;
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable String getTable();

        abstract @Nullable String getStorageIntegrationName();

        abstract @Nullable String getStagingBucketName();

        abstract @Nullable ValueProvider<String> getSnowPipe();

        abstract @Nullable Integer getFlushRowLimit();

        abstract @Nullable Integer getShardsNumber();

        abstract @Nullable Duration getFlushTimeLimit();

        abstract @Nullable String getFileNameTemplate();

        abstract @Nullable String getQuery();

        abstract @Nullable WriteDisposition getWriteDisposition();

        abstract @Nullable CreateDisposition getCreateDisposition();

        abstract @Nullable SnowflakeTableSchema getTableSchema();

        abstract @Nullable UserDataMapper getUserDataMapper();

        abstract @Nullable SnowflakeService getSnowflakeService();

        abstract @Nullable String getQuotationMark();

        abstract @Nullable StreamingLogLevel getDebugMode();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public Write<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Write<T> to(String table) {
            return this.toBuilder().setTable(table).build();
        }

        public Write<T> withStagingBucketName(String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Write<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Write<T> withQueryTransformation(String query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Write<T> withFileNameTemplate(String fileNameTemplate) {
            return this.toBuilder().setFileNameTemplate(fileNameTemplate).build();
        }

        public Write<T> withUserDataMapper(UserDataMapper userDataMapper) {
            return this.toBuilder().setUserDataMapper(userDataMapper).build();
        }

        public Write<T> withFlushTimeLimit(Duration triggeringFrequency) {
            return this.toBuilder().setFlushTimeLimit(triggeringFrequency).build();
        }

        public Write<T> withSnowPipe(String snowPipe) {
            return this.toBuilder().setSnowPipe((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)snowPipe)).build();
        }

        public Write<T> withSnowPipe(ValueProvider<String> snowPipe) {
            return this.toBuilder().setSnowPipe(snowPipe).build();
        }

        public Write<T> withShardsNumber(Integer shardsNumber) {
            return this.toBuilder().setShardsNumber(shardsNumber).build();
        }

        public Write<T> withFlushRowLimit(Integer rowsCount) {
            return this.toBuilder().setFlushRowLimit(rowsCount).build();
        }

        public Write<T> withWriteDisposition(WriteDisposition writeDisposition) {
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public Write<T> withCreateDisposition(CreateDisposition createDisposition) {
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public Write<T> withTableSchema(SnowflakeTableSchema tableSchema) {
            return this.toBuilder().setTableSchema(tableSchema).build();
        }

        public Write<T> withSnowflakeService(SnowflakeService snowflakeService) {
            return this.toBuilder().setSnowflakeService(snowflakeService).build();
        }

        public Write<T> withQuotationMark(String quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public Write<T> withDebugMode(StreamingLogLevel debugLevel) {
            return this.toBuilder().setDebugMode(debugLevel).build();
        }

        public PDone expand(PCollection<T> input) {
            this.checkArguments(input);
            PCollection out = this.getSnowPipe() != null ? this.writeStream(input, this.getStagingBucketName()) : this.writeBatch(input, this.getStagingBucketName());
            out.setCoder((Coder)StringUtf8Coder.of());
            return PDone.in((Pipeline)out.getPipeline());
        }

        private void checkArguments(PCollection<T> input) {
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName is required");
            Preconditions.checkArgument((this.getUserDataMapper() != null ? 1 : 0) != 0, (Object)"withUserDataMapper() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Preconditions.checkArgument((this.getSnowPipe() != null ? 1 : 0) != 0, (Object)"in streaming (unbounded) write it is required to specify SnowPipe name via withSnowPipe() method.");
            } else {
                Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"in batch writing it is required to specify destination table name via to() method.");
            }
        }

        private PCollection<T> writeStream(PCollection<T> input, String stagingBucketDir) {
            SnowflakeService snowflakeService = this.getSnowflakeService() != null ? this.getSnowflakeService() : new SnowflakeStreamingServiceImpl();
            PCollection inputInGlobalWindow = (PCollection)input.apply("Rewindow Into Global", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()), AfterPane.elementCountAtLeast((int)this.getFlushRowLimit())}))).discardingFiredPanes());
            int shards = this.getShardsNumber() > 0 ? this.getShardsNumber() : 1;
            PCollection files = this.writeFiles(inputInGlobalWindow, stagingBucketDir, shards);
            files = (PCollection)files.apply("Apply User Trigger", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()))).discardingFiredPanes());
            files = (PCollection)files.apply("Create list of files for loading via SnowPipe", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Concatenate()).withoutDefaults());
            return (PCollection)files.apply("Stream files to table", this.streamToTable(snowflakeService, stagingBucketDir));
        }

        private PCollection writeBatch(PCollection input, String stagingBucketDir) {
            SnowflakeService snowflakeService = this.getSnowflakeService() != null ? this.getSnowflakeService() : new SnowflakeBatchServiceImpl();
            PCollection files = this.writeBatchFiles(input, stagingBucketDir);
            ListCoder coder = ListCoder.of((Coder)StringUtf8Coder.of());
            files = (PCollection)files.getPipeline().apply(Reify.viewInGlobalWindow((PCollectionView)((PCollectionView)files.apply((PTransform)View.asList())), (Coder)coder));
            return (PCollection)files.apply("Copy files to table", this.copyToTable(snowflakeService, stagingBucketDir));
        }

        private PCollection writeBatchFiles(PCollection<T> input, String outputDirectory) {
            return this.writeFiles(input, outputDirectory, 0);
        }

        private PCollection<String> writeFiles(PCollection<T> input, String stagingBucketDir, int numShards) {
            PCollection mappedUserData = ((PCollection)((PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<T, Object[]>(){

                public Object[] apply(T element) {
                    return this.getUserDataMapper().mapRow(element);
                }
            }))).apply("Map Objects array to CSV lines", (PTransform)ParDo.of((DoFn)new MapObjectsArrayToCsvFn(this.getQuotationMark())))).setCoder((Coder)StringUtf8Coder.of());
            WriteFilesResult filesResult = (WriteFilesResult)mappedUserData.apply("Write files to specified location", (PTransform)FileIO.write().via((FileIO.Sink)TextIO.sink()).to(stagingBucketDir).withPrefix(UUID.randomUUID().toString().subSequence(0, 8).toString()).withSuffix(".csv").withNumShards(numShards).withCompression(Compression.GZIP));
            return (PCollection)filesResult.getPerDestinationOutputFilenames().apply("Parse KV filenames to Strings", (PTransform)Values.create());
        }

        private ParDo.SingleOutput<Object, Object> copyToTable(SnowflakeService snowflakeService, String stagingBucketDir) {
            return ParDo.of(new CopyToTableFn(this.getDataSourceProviderFn(), this.getTable(), this.getQuery(), stagingBucketDir, this.getStorageIntegrationName(), this.getCreateDisposition(), this.getWriteDisposition(), this.getTableSchema(), snowflakeService, this.getQuotationMark()));
        }

        protected PTransform streamToTable(SnowflakeService snowflakeService, String stagingBucketDir) {
            return ParDo.of(new StreamToTableFn(this.getDataSourceProviderFn(), this.getSnowPipe(), stagingBucketDir, this.getDebugMode(), snowflakeService));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setTable(String var1);

            abstract Builder<T> setStorageIntegrationName(String var1);

            abstract Builder<T> setStagingBucketName(String var1);

            abstract Builder<T> setQuery(String var1);

            abstract Builder<T> setSnowPipe(ValueProvider<String> var1);

            abstract Builder<T> setFlushRowLimit(Integer var1);

            abstract Builder<T> setShardsNumber(Integer var1);

            abstract Builder<T> setFlushTimeLimit(Duration var1);

            abstract Builder<T> setFileNameTemplate(String var1);

            abstract Builder<T> setUserDataMapper(UserDataMapper var1);

            abstract Builder<T> setWriteDisposition(WriteDisposition var1);

            abstract Builder<T> setCreateDisposition(CreateDisposition var1);

            abstract Builder<T> setTableSchema(SnowflakeTableSchema var1);

            abstract Builder<T> setSnowflakeService(SnowflakeService var1);

            abstract Builder<T> setQuotationMark(String var1);

            abstract Builder<T> setDebugMode(StreamingLogLevel var1);

            abstract Write<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        abstract @Nullable String getQuery();

        abstract @Nullable String getTable();

        abstract @Nullable String getStorageIntegrationName();

        abstract @Nullable String getStagingBucketName();

        abstract @Nullable CsvMapper<T> getCsvMapper();

        abstract @Nullable Coder<T> getCoder();

        abstract @Nullable SnowflakeService getSnowflakeService();

        abstract @Nullable String getQuotationMark();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public Read<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Read<T> fromQuery(String query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> fromTable(String table) {
            return this.toBuilder().setTable(table).build();
        }

        public Read<T> withStagingBucketName(String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Read<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Read<T> withCsvMapper(CsvMapper<T> csvMapper) {
            return this.toBuilder().setCsvMapper(csvMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withQuotationMark(String quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public PCollection<T> expand(PBegin input) {
            this.checkArguments();
            PCollection emptyCollection = (PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]));
            String tmpDirName = this.makeTmpDirName();
            PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)emptyCollection.apply((PTransform)ParDo.of((DoFn)new CopyIntoStageFn(this.getDataSourceProviderFn(), this.getQuery(), this.getTable(), this.getStorageIntegrationName(), this.getStagingBucketName(), tmpDirName, this.getSnowflakeService(), this.getQuotationMark())))).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)TextIO.readFiles())).apply((PTransform)ParDo.of((DoFn)new MapCsvToStringArrayFn(this.getQuotationMark())))).apply((PTransform)ParDo.of(new MapStringArrayToUserDataFn<T>(this.getCsvMapper())));
            output.setCoder(this.getCoder());
            ((PCollection)emptyCollection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{output}))).apply((PTransform)ParDo.of((DoFn)new CleanTmpFilesFromGcsFn(this.getStagingBucketName(), tmpDirName)));
            return output;
        }

        private void checkArguments() {
            Preconditions.checkArgument((this.getStorageIntegrationName() != null ? 1 : 0) != 0, (Object)"withStorageIntegrationName() is required");
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName() is required");
            Preconditions.checkArgument((this.getQuery() != null || this.getTable() != null ? 1 : 0) != 0, (Object)"fromTable() or fromQuery() is required");
            Preconditions.checkArgument((this.getQuery() == null || this.getTable() == null ? 1 : 0) != 0, (Object)"fromTable() and fromQuery() are not allowed together");
            Preconditions.checkArgument((this.getCsvMapper() != null ? 1 : 0) != 0, (Object)"withCsvMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
        }

        private String makeTmpDirName() {
            return String.format("sf_copy_csv_%s_%s", new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()), UUID.randomUUID().toString().subSequence(0, 8));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.getQuery() != null) {
                builder.add(DisplayData.item((String)"query", (String)this.getQuery()));
            }
            if (this.getTable() != null) {
                builder.add(DisplayData.item((String)"table", (String)this.getTable()));
            }
            builder.add(DisplayData.item((String)"storageIntegrationName", (String)this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"stagingBucketName", (String)this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"csvMapper", (String)this.getCsvMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        public static class CleanTmpFilesFromGcsFn
        extends DoFn<Object, Object> {
            private final String stagingBucketDir;
            private final String tmpDirName;

            public CleanTmpFilesFromGcsFn(String stagingBucketDir, String tmpDirName) {
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String combinedPath = String.format("%s/%s/**", this.stagingBucketDir, this.tmpDirName);
                List paths = FileSystems.match((String)combinedPath).metadata().stream().map(metadata -> metadata.resourceId()).collect(Collectors.toList());
                FileSystems.delete(paths, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
            }
        }

        private static class MapStringArrayToUserDataFn<T>
        extends DoFn<String[], T> {
            private final CsvMapper<T> csvMapper;

            public MapStringArrayToUserDataFn(CsvMapper<T> csvMapper) {
                this.csvMapper = csvMapper;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                context.output(this.csvMapper.mapRow((String[])context.element()));
            }
        }

        public static class MapCsvToStringArrayFn
        extends DoFn<String, String[]> {
            private String quoteChar;

            public MapCsvToStringArrayFn(String quoteChar) {
                this.quoteChar = quoteChar;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String csvLine = (String)c.element();
                CSVParser parser = new CSVParserBuilder().withQuoteChar(this.quoteChar.charAt(0)).build();
                String[] parts = parser.parseLine(csvLine);
                c.output((Object)parts);
            }
        }

        private static class CopyIntoStageFn
        extends DoFn<Object, String> {
            private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
            private final String query;
            private final String table;
            private final String database;
            private final String schema;
            private final String tmpDirName;
            private final String storageIntegrationName;
            private final String stagingBucketDir;
            private final SnowflakeService snowflakeService;
            private final String quotationMark;

            private CopyIntoStageFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, String query, String table, String storageIntegrationName, String stagingBucketDir, String tmpDirName, SnowflakeService snowflakeService, String quotationMark) {
                this.dataSourceProviderFn = dataSourceProviderFn;
                this.query = query;
                this.table = table;
                this.storageIntegrationName = storageIntegrationName;
                this.snowflakeService = snowflakeService;
                this.quotationMark = quotationMark;
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
                DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
                DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
                this.database = config.getDatabase();
                this.schema = config.getSchema();
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                String stagingBucketRunDir = String.format("%s/%s/run_%s/", this.stagingBucketDir, this.tmpDirName, UUID.randomUUID().toString().subSequence(0, 8));
                SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, this.database, this.schema, this.table, this.query, this.storageIntegrationName, stagingBucketRunDir, this.quotationMark);
                String output = this.snowflakeService.read(config);
                context.output((Object)output);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setQuery(String var1);

            abstract Builder<T> setTable(String var1);

            abstract Builder<T> setStorageIntegrationName(String var1);

            abstract Builder<T> setStagingBucketName(String var1);

            abstract Builder<T> setCsvMapper(CsvMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setSnowflakeService(SnowflakeService var1);

            abstract Builder<T> setQuotationMark(String var1);

            abstract Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface UserDataMapper<T>
    extends Serializable {
        public Object[] mapRow(T var1);
    }

    @FunctionalInterface
    public static interface CsvMapper<T>
    extends Serializable {
        public T mapRow(String[] var1) throws Exception;
    }
}

