/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_io_redis.com.google.common.base.Preconditions;
import org.apache.beam.sdk.io.redis.AutoValue_RedisConnectionConfiguration;
import org.apache.beam.sdk.transforms.display.DisplayData;
import redis.clients.jedis.Jedis;

@AutoValue
public abstract class RedisConnectionConfiguration
implements Serializable {
    abstract String host();

    abstract int port();

    @Nullable
    abstract String auth();

    abstract int timeout();

    abstract Builder builder();

    public static RedisConnectionConfiguration create() {
        return new AutoValue_RedisConnectionConfiguration.Builder().setHost("localhost").setPort(6379).setTimeout(2000).build();
    }

    public static RedisConnectionConfiguration create(String host, int port) {
        return new AutoValue_RedisConnectionConfiguration.Builder().setHost(host).setPort(port).setTimeout(2000).build();
    }

    public RedisConnectionConfiguration withHost(String host) {
        Preconditions.checkArgument(host != null, "host can not be null");
        return this.builder().setHost(host).build();
    }

    public RedisConnectionConfiguration withPort(int port) {
        Preconditions.checkArgument(port > 0, "port can not be negative or 0");
        return this.builder().setPort(port).build();
    }

    public RedisConnectionConfiguration withAuth(String auth) {
        Preconditions.checkArgument(auth != null, "auth can not be null");
        return this.builder().setAuth(auth).build();
    }

    public RedisConnectionConfiguration withTimeout(int timeout) {
        Preconditions.checkArgument(timeout >= 0, "timeout can not be negative");
        return this.builder().setTimeout(timeout).build();
    }

    public Jedis connect() {
        Jedis jedis = new Jedis(this.host(), this.port(), this.timeout());
        if (this.auth() != null) {
            jedis.auth(this.auth());
        }
        return jedis;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"host", (String)this.host()));
        builder.add(DisplayData.item((String)"port", (Integer)this.port()));
        builder.addIfNotNull(DisplayData.item((String)"timeout", (Integer)this.timeout()));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setHost(String var1);

        abstract Builder setPort(int var1);

        abstract Builder setAuth(String var1);

        abstract Builder setTimeout(int var1);

        abstract RedisConnectionConfiguration build();
    }
}

