/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RedisCursor
implements Comparable<RedisCursor>,
Serializable {
    private final String cursor;
    private final long dbSize;
    private final boolean isStart;
    private static BigEndianLongCoder coder = BigEndianLongCoder.of();
    public static final ByteKey ZERO_KEY = ByteKey.of((int[])new int[]{0});
    public static final RedisCursor ZERO_CURSOR = RedisCursor.of("0", 8L, true);
    public static final RedisCursor END_CURSOR = RedisCursor.of("0", 8L, false);

    public static RedisCursor of(String cursor, long dbSize, boolean isStart) {
        return new RedisCursor(cursor, dbSize, isStart);
    }

    private RedisCursor(String cursor, long dbSize, boolean isStart) {
        this.cursor = cursor;
        this.dbSize = dbSize;
        this.isStart = isStart;
    }

    @Override
    public int compareTo(@Nonnull RedisCursor other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        if ("0".equals(this.cursor) && "0".equals(other.cursor)) {
            if (this.isStart && !other.isStart()) {
                return -1;
            }
            if (!this.isStart && other.isStart()) {
                return 1;
            }
            return 0;
        }
        return Long.compare(Long.parseLong(this.cursor), Long.parseLong(other.cursor));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisCursor that = (RedisCursor)o;
        return this.dbSize == that.dbSize && this.isStart == that.isStart && Objects.equals(this.cursor, that.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.dbSize, this.isStart);
    }

    public String getCursor() {
        return this.cursor;
    }

    public long getDbSize() {
        return this.dbSize;
    }

    public boolean isStart() {
        return this.isStart;
    }

    @VisibleForTesting
    static ByteKey redisCursorToByteKey(RedisCursor cursor) {
        if ("0".equals(cursor.getCursor())) {
            if (cursor.isStart()) {
                return ByteKey.of((int[])new int[]{0});
            }
            return ByteKey.EMPTY;
        }
        int nBits = RedisCursor.getTablePow(cursor.getDbSize());
        long cursorLong = Long.parseLong(cursor.getCursor());
        long reversed = RedisCursor.shiftBits(cursorLong, nBits);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            coder.encode(Long.valueOf(reversed), (OutputStream)os);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid redis cursor " + cursor);
        }
        byte[] byteArray = os.toByteArray();
        return ByteKey.copyFrom((byte[])byteArray);
    }

    @VisibleForTesting
    static long shiftBits(long a, int nBits) {
        long b = 0L;
        for (int i = 0; i < nBits; ++i) {
            b <<= 1;
            b |= a & 1L;
            a >>= 1;
        }
        return b;
    }

    @VisibleForTesting
    static int getTablePow(long nKeys) {
        return 64 - Long.numberOfLeadingZeros(nKeys - 1L);
    }

    @VisibleForTesting
    static RedisCursor byteKeyToRedisCursor(ByteKey byteKeyStart, long nKeys, boolean isStart) {
        if (byteKeyStart.isEmpty()) {
            return RedisCursor.of("0", nKeys, false);
        }
        if (byteKeyStart.equals((Object)ByteKey.of((int[])new int[]{0}))) {
            return RedisCursor.of("0", nKeys, true);
        }
        int nBits = RedisCursor.getTablePow(nKeys);
        ByteBuffer bb = ByteBuffer.wrap(byteKeyStart.getBytes());
        long l = bb.getLong();
        l = RedisCursor.shiftBits(l, nBits);
        return RedisCursor.of(Long.toString(l), nKeys, isStart);
    }
}

